#include "paratrooper.h"
#include "message.h"
#include "globals.h"
#include "vector.h"
#include <stdio.h>

Message::Message()
{
    set_str("");
    next = 0;
    vector_set(pos, 0, 0, 0);
    vector_set(v, 0, 0, 0);
    vector_set(scale, 1, 1, 1);
    msg_font = gl_avantgarde;
    al_font = avantgarde;
    frame = 0;
    color = makecol(0, 0, 0);
}

Message::Message(char const *new_str)
{
    set_str(new_str);
    next = 0;
    vector_set(pos, 0, 0, 0);
    vector_set(v, 0, 0, 0);
    vector_set(scale, 1, 1, 1);
    msg_font = gl_avantgarde;
    al_font = avantgarde;
    frame = 0;
    color = makecol(0, 0, 0);
}

char const *Message::get_str() const
{
    return str.c_str();
}

void Message::set_str(char const *new_str)
{
    str = new_str;
}

// draw the string _centered_ around pos.
// text height is assumed to be 1, so correct ypos by 0.5
// text length has to be computed
void Message::draw()
{
    float scalefactor = text_height(al_font);
    
    glPushMatrix();
    glEnable(GL_TEXTURE_2D);
    
    // translate and scale
    glTranslatefv(pos);
    glScalefv(scale);

    // draw the string
    allegro_gl_printf(msg_font,
		      -text_length(al_font, str.c_str()) / (2.0 * scalefactor),
		      0.5, 0,
		      color,
		      const_cast<char *>(str.c_str()));

//    printf("scalefactor: %f, length: %f\n", scalefactor, -text_length(al_font, str.c_str()) / (2.0 * scalefactor));
	   
    
    glDisable(GL_TEXTURE_2D);    
    glPopMatrix();
}

void Message::update()
{
//    printf("message %s: state %d pos (%f %f %f) v (%f %f %f) scale (%f %f %f) color %d \n",
//	   str.c_str(), state, pos[0], pos[1], pos[2], v[0], v[1], v[2], scale[0], scale[1], scale[2], color);
    
    if (state == STATIC || state == DEAD)
    {
	return;
    }

    frame++;
    
    if (state == APPEAR)
    {
	if (frame > MAX_APPEAR_FRAME)
	{
	    state = PRESENT;
	    frame = 0;
	    return;
	}

	vector_add(pos, v);
    }

    if (state == PRESENT)
    {
	if (frame > MAX_PRESENT_FRAME)
	{
	    state = DISAPPEAR;
	    frame = 0;
	    return;
	}
    }
    
    if (state == DISAPPEAR)
    {
	if (frame > MAX_DISAPPEAR_FRAME)
	{
	    state = DEAD;
	    frame = 0;
	    return;
	}
	vector_add(pos, v);	
    }
}

// strings are drawn centered around pos
// z coordinate is always -2.1

void Message::leftright()
{
    frame = 0;
    vector_set(pos, -2, 0, -2.1);
    vector_set(v, 2.0 / MAX_APPEAR_FRAME, 0, 0);
    state = APPEAR;
}

void Message::rightleft()
{
    frame = 0;
    vector_set(pos, 2, 0, -2.1);
    vector_set(v, -2.0 / MAX_APPEAR_FRAME, 0, 0);
    state = APPEAR;
}
    
void Message::updown()
{
    frame = 0;
    vector_set(pos, 0, 2, -2.1);
    vector_set(v, 0, -2.0 / MAX_APPEAR_FRAME, 0);
    state = APPEAR;
}

void Message::downup()
{
    frame = 0;
    vector_set(pos, 0, -2, -2.1);
    vector_set(v, 0, 2.0 / MAX_APPEAR_FRAME, 0);
    state = APPEAR;
}
