#include "paratrooper.h"
#include "globals.h"

// draw a health bar on the side
void draw_health_bar()
{
    // put it on a quad
    // screen projection is on the near clipping plane, from
    // -0.8,-0.6 to 0.8,0.6 at z = -2

    float health = 1.0 - (gun->activists / (float)MAX_ACTIVISTS);
    if (health < 0)
	health = 0;

    // disable depth buffering to enable drawing quads on top of eachother
    glDisable(GL_DEPTH_TEST);
    
    glBegin(GL_QUADS);

    // gray background, transparent
    glColor4fv(gray_trans);

    glVertex3f(0.7, 0.0, -2.1);
    glVertex3f(0.75, 0.0, -2.1);
    glVertex3f(0.75, 0.5, -2.1);
    glVertex3f(0.7, 0.5, -2.1);

    // actual health
    // color depends on status

    if (health > 0.5)
	glColor4fv(green_trans);
    else if (health > 0.2)
	glColor4fv(orange_trans);
    else
	glColor4fv(red_trans);
    
    glVertex3f(0.71, 0.01, -2.1);
    glVertex3f(0.74, 0.01, -2.1);
    glVertex3f(0.74, 0.05 + health * 0.44, -2.1);
    glVertex3f(0.71, 0.05 + health * 0.44, -2.1);

    glEnd();
    glEnable(GL_DEPTH_TEST);
}
