#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#include "paratrooper.h"
#include "trooper.h"
#include "chopper.h"
#include "gun.h"
#include "bullet.h"
#include "tree.h"
#include "explosion.h"
#include "message.h"
#include "wave.h"

// #include "gun.h"
// #include "hercules.h"

extern Trooper   *troopers;
extern Chopper   *choppers;
// extern Hercules *hercules;

extern Gun       *gun;
extern Bullet    *bullets;
extern Tree      *trees;
extern Explosion *explosions;
extern Message   *messages;
extern Wave      *wave;

// colors
extern float sky[3];
extern float chopper[3];
extern float light_gray[3];
extern float dark_gray[3];
extern float barrel[3];
extern float red[3];
extern float green[3];
extern float orange[3];
extern float stem[3];
extern float leaf[3];

// transparent colors
extern float gray_trans[4];
extern float red_trans[4];
extern float green_trans[4];
extern float blue_trans[4];
extern float orange_trans[4];
extern float chopper_trans[4];
extern float fire_trans[4];

extern int crosshair_tex;

extern BITMAP *crosshair_bmp;

extern void init_globals();
extern void shutdown_globals();
extern void timer_func();

extern int game_over;
extern int paused;
extern int loop;
extern int score;
extern int fps;

extern DATAFILE *data;
extern DATAFILE *sound;

extern FONT *avantgarde;
extern FONT *gl_avantgarde;

extern SAMPLE *samp_explode;
extern SAMPLE *samp_chopper;
extern SAMPLE *samp_reload;
extern SAMPLE *samp_gun;
extern SAMPLE *samp_crash;
extern SAMPLE *samp_alarm;

#endif

