#include "paratrooper.h"
#include "globals.h"
#include "texture.h"
#include "sound.h"
#include "avantgarde.h"

Trooper     *troopers = 0;
Chopper     *choppers = 0;
// Hercules *hercules = 0;

Gun              *gun = 0;
Bullet       *bullets = 0;
Tree           *trees = 0;
Explosion *explosions = 0;
Message     *messages = 0;
Wave            *wave = 0;

// colors
float sky[3] = {0.6, 0.7, 1.0};
float chopper[3] = {0.1, 0.2, 0.05};
float dark_gray[3] = {0.3, 0.3, 0.3};
float light_gray[3] = {0.55, 0.55, 0.55};
float barrel[3] = {0.05, 0.05, 0.1};
float red[3] = {1, 0, 0};
float green[3] = {0.2, 0.8, 0.1};
float blue[3] = {0, 0, 1};
float orange[3] = {1, 0.5, 0};
float stem[3] = {0.1, 0.1, 0};
float leaf[3] = {0.1, 0.5, 0};

// colors with transparency
float gray_trans[4] = {0.5, 0.5, 0.5, 0.3};
float red_trans[4] = {1, 0, 0, 0.5};
float green_trans[4] = {0.2, 0.8, 0.1, 0.5};
float orange_trans[4] = {1, 0.5, 0, 0.5};
float chopper_trans[4] = {0.1, 0.2, 0.05, 0.5};
float blue_trans[4] = {0, 0, 1, 0.5};
float fire_trans[4] = {1, 0.7, 0, 0.3};

int crosshair_tex;

int game_over = 0;
int paused = 0;
int loop = 0;
int score = 0;
int fps = 0;

BITMAP *crosshair_bmp;

DATAFILE *data;
DATAFILE *sound;

FONT *avantgarde;
FONT *gl_avantgarde;

SAMPLE *samp_explode;
SAMPLE *samp_chopper;
SAMPLE *samp_reload;
SAMPLE *samp_gun;
SAMPLE *samp_crash;
SAMPLE *samp_alarm;

void init_globals()
{
    int format;
    
    gun = 0;
    wave = 0;
    choppers = 0;
    troopers = 0;
    bullets = 0;
    trees = 0;
    loop = 0;
    score = 0;
    fps = 0;
    paused = 0;
    game_over = 0;
    wave = new Wave;
    // allocate gun _after_ data initialization
    
    // we (temporarily) need GL_ALPHA format for font transparency,
    // otherwise allegro thinks we want a font without alpha channel.
    format = allegro_gl_set_texture_format(GL_ALPHA8);
    
    avantgarde = (FONT *)(data[AVANTGARDE].dat);
    gl_avantgarde = allegro_gl_convert_allegro_font(avantgarde,
						    AGL_FONT_TYPE_TEXTURED,
						    text_height(avantgarde));
    // reset texture format
    allegro_gl_set_texture_format(format);
    

    samp_explode = (SAMPLE *)(sound[EXPLODE].dat);
    samp_alarm   = (SAMPLE *)(sound[ALARM].dat);
    samp_chopper = (SAMPLE *)(sound[HELICOPTER].dat);
    samp_reload  = (SAMPLE *)(sound[RELOAD].dat);
    samp_crash   = (SAMPLE *)(sound[CRASH].dat);
    samp_gun     = (SAMPLE *)(sound[CANNON].dat);

    // only after loading data can we initialize the gun (it uses samples)
    gun = new Gun;
    
    // make the crosshair
    crosshair_bmp = create_bitmap_ex(24, 128, 128);

    // GL calls inside
    allegro_gl_begin();
    make_crosshair();
    allegro_gl_end();

    // generate some trees
    make_trees();
}

void shutdown_globals()
{
    delete_choppers(true);
    delete_troopers(true);
    delete_bullets(true);
    delete_trees(true);
    delete_explosions(true);
    delete_messages(true);
    
    delete gun;
    delete wave;
    
    choppers = 0;
    troopers = 0;
    bullets = 0;
    trees = 0;
    explosions = 0;
    messages = 0;
    gun = 0;
    wave = 0;

    destroy_bitmap(crosshair_bmp);
}

void make_trees()
{
    for (int i = 0; i < TREES; i++)
    {
	Tree *t = new Tree;
	t->next = trees;
	trees = t;
    }
}

void timer_func()
{
    loop++;
}
END_OF_FUNCTION(timer_func);
