#include "paratrooper.h"
#include "explosion.h"
#include "vector.h"
#include "globals.h"
#include "sphere.h"

Explosion::Explosion()
{
    vector_set(pos, 0, 0, 0);
    state = ALIVE;
    radius = 3.0;
    duration = 20;
    next = 0;
}

void Explosion::draw()
{
    float factor = state * radius / duration;
    
    // draw your standard expanding yellow ring.
    // this should really be an expanding yellow sphere, of course.
    // heck, why not. We'll make an expanding yellow sphere.

    glPushMatrix();
//    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

    glTranslatefv(pos);
    glColor4fv(fire_trans);

    glScalef(factor, factor, factor);
    draw_sphere(2);
    
//    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glPopMatrix();
}

void Explosion::update()
{
    if (++state > duration)
	state = DEAD;
}
