#include <stdio.h>
#include <math.h>
#include "paratrooper.h"
#include "triangle.h"

void draw_cylinder(float bot, float top, int level)
{
    // this cylinder has a default radius of 1, to be able to normalize
    // properly without passing the radius.
    
    // draw a box out of triangles
    float r = 1.0;

    float v1[3] = {-r, -0, bot};
    float v2[3] = {0, -r, bot};
    float v3[3] = {0, -r, top};
    float v4[3] = {-r, -0, top};
    

    glPushMatrix();
    for (int i = 0; i < 4; i++)
    {
	// two triangles forming a square
	glBegin(GL_TRIANGLES);

//	printf("dividing triangle: [%f, %f, %f] [%f, %f, %f] [%f, %f, %f]\n",
//	       v1[0],v1[1],v1[2],v2[0],v2[1],v2[2],v3[0],v3[1],v3[2]);
	divide_triangle_cylinder(v1, v2, v3, level);
	divide_triangle_cylinder(v1, v3, v4, level);

	glEnd();

	// next side
	glRotatef(90, 0, 0, 1);
    }
    glPopMatrix();

//    glColor3f(0, 0, 0);
//    glBegin(GL_LINES);
//    glVertex3f(0, 0, 0);
//    glVertex3f(0, 0, 10);
//    glEnd();
}
