#ifndef _CHOPPER_H_
#define _CHOPPER_H_

// helicopter class for paratrooper
// contains only a few variables:
//
// number of paratroopers
// pos, v
// state
// rotor angle
//
// helicopters can be shot down, taking paratroopers with them.

class Chopper
{
public:

    enum chopper_state
    {
	DEAD = 0,
	FLYING,
	DROPPING,
	FALLING,
	WRECK
    };

    // constructor
    Chopper();
    ~Chopper();
    
    // draw functions
    void draw();
    void draw_body();
    void draw_rotor();
    void draw_tail_rotor();
    
    // update
    void update();

    // drop a trooper
    void drop_trooper();

    // collisions
    int contains(float *p1, float *p2);
    void explode(float radius = 7);
    
    float pos[3];
    float v[3];
    float angle;
    float dir_degree;
    float dir_radian;
    int state;
    int ntroopers;
    int time_to_drop;

    // linked list
    Chopper *next;

    int voice_chopper;
};

#endif

