#include "paratrooper.h"
#include "vector.h"
#include <stdio.h>


void draw_box(float *c1, float *c2)
{
    // draw a box between corners c1 and c2

    glBegin(GL_QUAD_STRIP);
    glVertex3fv(c1);
    glVertex3f(c1[0], c1[1], c2[2]);

    glVertex3f(c2[0], c1[1], c1[2]);
    glVertex3f(c2[0], c1[1], c2[2]);

    glVertex3f(c2[0], c2[1], c1[2]);
    glVertex3fv(c2);

    glVertex3f(c1[0], c2[1], c1[2]);
    glVertex3f(c1[0], c2[1], c2[2]);

    glVertex3fv(c1);
    glVertex3f(c1[0], c1[1], c2[2]);
    glEnd();

    // end caps
    glBegin(GL_QUADS);

    glVertex3fv(c1);
    glVertex3f(c1[0], c2[1], c1[2]);
    glVertex3f(c2[0], c2[1], c1[2]);
    glVertex3f(c2[0], c1[1], c1[2]);

    glVertex3fv(c2);
    glVertex3f(c1[0], c2[1], c2[2]);
    glVertex3f(c1[0], c1[1], c2[2]);
    glVertex3f(c2[0], c1[1], c2[2]);

    glEnd();
}

void draw_box(float c1x, float c1y, float c1z,
		     float c2x, float c2y, float c2z)
{
    float
	c1[3] = {c1x, c1y, c1z},
	c2[3] = {c2x, c2y, c2z};
	
    draw_box(c1, c2);
}

int intersect_xy(float *l1, float *l2, float *r1, float *r2)
{
    // check if rectangle (in xy plain) r is intersected by line l
    // determine coordinates of l on plane r

    float x[3];
    float factor;
        
    ASSERT(r1[2] == r2[2]);

    // make sure the z coordinates are ok
    if ((l1[2] < r1[2] && l2[2] < r1[2])
	||
	(l1[2] > r1[2] && l2[2] > r1[2]))
    {
	// both line points on 1 side of the plane
	return 0;
    }
    
    // interpolation factor
    factor = (r1[2] - l1[2]) / (l2[2] - l1[2]);

    x[0] = l1[0] + factor * (l2[0] - l1[0]);
    x[1] = l1[1] + factor * (l2[1] - l1[1]);
    x[2] = r1[2];   // z coordinate on the plane

    // check if x is between r1 and r2
    if (
	((x[0] > r1[0] && x[0] < r2[0]) || (x[0] > r2[0] && x[0] > r1[0]))
	&&
	((x[1] > r1[1] && x[1] < r2[1]) || (x[1] > r2[1] && x[1] > r1[1]))
       )
    {
	return 1;
    }
    else
    {
	return 0;
    }
}

int intersect_yz(float *l1, float *l2, float *r1, float *r2)
{
    // check if rectangle (in yz plain) r is intersected by line l
    // determine coordinates of l on plane r

    float x[3];
    float factor;
        
    ASSERT(r1[0] == r2[0]);

    // make sure the x coordinates are ok
    if ((l1[0] < r1[0] && l2[0] < r1[0])
	||
	(l1[0] > r1[0] && l2[0] > r1[0]))
    {
	// both line points on 1 side of the plane
	return 0;
    }
    
    // interpolation factor
    factor = (r1[0] - l1[0]) / (l2[0] - l1[0]);

    x[2] = l1[2] + factor * (l2[2] - l1[2]);
    x[1] = l1[1] + factor * (l2[1] - l1[1]);
    x[0] = r1[0];   // x coordinate on the plane

    // check if x is between r1 and r2
    if (
	((x[2] > r1[2] && x[2] < r2[2]) || (x[2] > r2[2] && x[2] > r1[2]))
	&&
	((x[1] > r1[1] && x[1] < r2[1]) || (x[1] > r2[1] && x[1] > r1[1]))
       )
    {
	return 1;
    }
    else
    {
	return 0;
    }
}

int intersect_xz(float *l1, float *l2, float *r1, float *r2)
{
    // check if rectangle (in xz plain) r is intersected by line l
    // determine coordinates of l on plane r

    float x[3];
    float factor;
        
    ASSERT(r1[1] == r2[1]);

    // make sure the y coordinates are ok
    if ((l1[1] < r1[1] && l2[1] < r1[1])
	||
	(l1[1] > r1[1] && l2[1] > r1[1]))
    {
	// both line points on 1 side of the plane
	return 0;
    }
    
    // interpolation factor
    factor = (r1[1] - l1[1]) / (l2[1] - l1[1]);

    x[0] = l1[0] + factor * (l2[0] - l1[0]);
    x[2] = l1[2] + factor * (l2[2] - l1[2]);
    x[1] = r1[1];   // y coordinate on the plane

    // check if x is between r1 and r2
    if (
	((x[0] > r1[0] && x[0] < r2[0]) || (x[0] > r2[0] && x[0] > r1[0]))
	&&
	((x[2] > r1[2] && x[2] < r2[2]) || (x[2] > r2[2] && x[2] > r1[2]))
       )
    {
	return 1;
    }
    else
    {
	return 0;
    }
}
    
// check if box [b1, b2] is intersected by line [l1, l2]
int intersect_box(float *l1, float *l2, float *b1, float *b2)
{
    float
	r1[3] = {b2[0], b1[1], b2[2]},
	r2[3] = {b1[0], b2[1], b2[2]},
	r3[3] = {b2[0], b2[1], b1[2]};

    if (intersect_xy(l1, l2, b1, r3))
	return 1;
    if (intersect_xy(l1, l2, r1, r2))
	return 1;
    if (intersect_yz(l1, l2, b1, r2))
	return 1;
    if (intersect_yz(l1, l2, r1, r3))
	return 1;
    if (intersect_xz(l1, l2, b1, r1))
	return 1;
    if (intersect_xz(l1, l2, r2, r3))
	return 1;

    return 0;
}

int point_in_box(float *p, float *b1, float *b2)
{
    // 3 different indices
    for (int i = 0; i < 3; i++)
    {
	// you don't know which end of the box is smallest
	if ((p[i] > b1[i] && p[i] > b2[i])
	    ||
	    (p[i] < b2[i] && p[i] < b1[i]))
	{
	    return 0;
	}
    }
    
    return 1;
}

int intersect_box(float *l1, float *l2, float *b1, float *b2, int n)
{
    // in n steps, check if points on line (l1, l2) fall in box (b1, b2)

    float factor = 0;
    float diff[3];
    float dd[3];

    vector_subtract(l2, l1, diff);    // line vector
    
    for (int i = 0; i <= n; i++)
    {
	// compute partial line vector
	factor = i / (float)n;
	vector_assign(dd, diff);
	vector_multiply(dd, factor);
	vector_add(dd, l1);

	// dd should now be a point on the line somewhere between l1 and l2
	if (point_in_box(dd, b1, b2))
	{
//	    printf("point_in_box found: [%f %f %f] [%f %f %f] [%f %f %f]\n",
//		   dd[0], dd[1], dd[2], b1[0], b1[1], b1[2], b2[0], b2[1], b2[2]);
	    
	    return 1;
	}
    }

    return 0;
}
