#include "main.h"

BITMAP *buffer;
volatile int cur=1;
FONT *my_font;
DATAFILE *data;
GameCom *gc;
MOUSE_CLASS mouse;
PLAYER_CLASS player[2];
int FONT_H;
char local_name[40];
bool server;
int peer;
int p_local;
int p_net;
unsigned char packet[40];
char chat_string[40];
TEXT_CLASS chat_list[2];
BOARD_CLASS board;
long seed;
int turn=0;
D_POINT m2;


void inc_cur()
{
	cur=-cur;
}

END_OF_FUNCTION(inc_cur);

void doError(AL_CONST char *msg, ...)
{
    char buf[1024];

    va_list ap;
    va_start(ap, msg);
    vsprintf(buf,msg,ap); 
    va_end(ap);

    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Allegro Error Message:\n %s",buf);

    deleteAll();

    exit(1);
}

// initialize allegro and the data
int initAll()
{
    allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();

    set_window_title("NetFour");
	
    if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) 
    {
        doError("Unable initialize sound module\n%s\n", allegro_error);
    }

    if (set_gfx_mode(GFX_AUTODETECT,640,480,0,0)!=0)
    {
        doError("Unable initialize graphics module\n%s\n", allegro_error);
    }

    data=load_datafile("data.dat");
    set_palette((RGB*)data[MY_PAL].dat);
    my_font=font;//(FONT*)data[MY_FONT].dat;
    FONT_H=text_height(my_font);
	
    buffer=create_bitmap(SCREEN_W,SCREEN_H);
    clear_bitmap(buffer);

    mouse.init();
    mouse.Show();

    srand(time(NULL));

	LOCK_VARIABLE(cur);
	LOCK_FUNCTION(inc_cur);
 	install_int(inc_cur, 250);

    text_mode(-1);

    server=false;

    srand(time(NULL));

    strcpy(player[0].name,"SERVER");
    strcpy(player[1].name,"CLIENT");

    return 0;
}

// free all memory used
void deleteAll()
{
    mouse.uninit();
    if (data)
        unload_datafile(data);
    if (buffer)
        destroy_bitmap(buffer);
}

// draw everything
void drawAll()
{
    drawScreen(buffer);
}

// draw the buffer to the screen
void drawScreen(BITMAP *bmp)
{
    int x,y;
    x=mouse_x;
    y=mouse_y;

    blit(bmp,mouse.under,x,y,0,0,32,32);
    mouse.draw(bmp);

    acquire_screen();
    blit(bmp,screen,0,0,0,0,SCREEN_W,SCREEN_H);
    release_screen();

    blit(mouse.under,bmp,0,0,x,y,32,32);
}

void openScreen()
{
    BOARD_CLASS temp;
    BITMAP *bmp;
    int x[]={3,2,4,5,1,5,4,3,2,4,5,5};
    int c[]={0,1,0,1,0,1,0,1,0,1,0,1};
    temp.clear();
    for (int i=0; i<12; i++)
    {
        temp.place(x[i],c[i]);
    }
    bmp=create_bitmap(SCREEN_W,SCREEN_H);
    temp.draw(bmp);

    clear_bitmap(buffer);
    blit(bmp,buffer,4,4,40,60,560,360);
    textout_centre(buffer,font,"Press Enter to Continue!",SCREEN_W/2,SCREEN_H-20,255);

    dtextout_centre(buffer,(FONT*)data[MY_FONT].dat,"NetFour",SCREEN_W/2,4,10,2);

    mouse.Hide();

    while (!key[KEY_ENTER])
    {
        drawScreen(buffer);
    }

    while (key[KEY_ENTER]) {}

    mouse.Show();
    destroy_bitmap(bmp);
}


void main_menu()
{
    BUTTON_CLASS button[3];
    bool done=false;
    int x,y,yy,s,w;

    w=text_length(my_font,"2-Player (Online)")+20;
    x=(SCREEN_W-w)/2;
    y=SCREEN_H/2-100;
    yy=0;
    s=FONT_H+6;


    button[0].create(x,y,w,s,0,"2-Player (Offline)");yy+=s+8;    
    button[1].create(x,y+yy,w,s,0,"2-Player (Online)");yy+=s+8;
    button[2].create(x,y+yy,w,s,0,"Quit");

    while (!done)
    {
        //drawWindow(buffer,0,0,SCREEN_W-1,SCREEN_H-1,UP);
        drawWindow(buffer,(SCREEN_W-w)/2-10,SCREEN_H/2-120,(SCREEN_W+w)/2+10,SCREEN_H/2,UP);
        for (int i=0; i<3; i++)
        {
            button[i].draw(buffer);
        }
        drawScreen(buffer);

        if (mouse.click())
        {  
            x=mouse_x;
            y=mouse_y;

            if (button[0].isMouse(x,y))
            {
                doGame(TYPE_SOLO);
            }

            if (button[1].isMouse(x,y))
            {
                doGame(TYPE_PEER);
            }

            if (button[2].isMouse(x,y))
            {
                if (doQuestion(buffer,-1,-1,2," Yes ","No",
                    "Are you sure that you",
                    "want to end your game?"))
                {
                    done=true;
                }
            }
        }
    
        if (key[KEY_ESC])
        {
            while (key[KEY_ESC]) {}
            if (doQuestion(buffer,-1,-1,2," Yes ","No",
                    "Are you sure that you",
                    "want to end your game?"))
            {
                done=true;
            }
        }            
    }
}


// main loop
int main()
{
    if (initAll()<0) return -1;

    openScreen();

    main_menu();

    deleteAll();

    return 0;
}
END_OF_MAIN();
