#include "main.h"
  
char server_address[256];

int waitForPeer()
{
    bool done=false;
    GCMessage *m;
    char str[40];

    if (server)
    {
        p_local=0;
        p_net=1;
        doMessage2(buffer,-1,-1,2,"Waiting for a friend to Connect.","(Press ESC to Cancel at any time)");
    }
    else
    {
        p_local=1;
        p_net=0;
        doMessage2(buffer,-1,-1,2,"Waiting for a server to Respond.","(Press ESC to Cancel at any time)");
    }

    while (!done)
    {
        drawScreen(buffer);

        if (key[KEY_ESC]) 
        {
            while (key[KEY_ESC]) {}
            return -1;
        }

        while ((m = gc->GetMessage()) != NULL) 
        { 
            // Check if this is a request from a peer to be added 
            if ( m->Channel() == GCOM_HELLO) 
            { 
                // Check that peer ID is 0 which means this peer hasn't been added already 
                if (m->PeerID() == 0) 
                { 
                    // Add peer 
                    peer = gc->AddPeer(m->Address()); 
                    // Did we succeed?
                    if (peer!=-1)
                    {
                        convertToString(str,m);
                        strcpy(player[1].name,str);

                        gc->QueueMessage(peer,GCOM_HELLO_REPLY,local_name);

                        seed = rand();
                        srnd(seed);
                        sirnd(seed);
                        convert_long_to_char(packet,seed);
                        gc->QueueMessage(peer,GCOM_GET_SEED,(void*)packet,40);
                        done=true;
                    }
                    else
                    {
                        return -2;
                    } 
                }
            } 

            // Check if this is a request from a peer to be added 
            if ( m->Channel() == GCOM_HELLO_REPLY) 
            { 
                convertToString(str,m);
                strcpy(player[0].name,str);
            } 

            // Check if this is a request from a peer to be added 
            if ( m->Channel() == GCOM_GET_SEED) 
            { 
                convertToUString(packet,m);
            	seed = convert_char_to_long(packet);
                srnd(seed);
                sirnd(seed);
                done=true;
            }
        }
    }

    drawWindow(buffer,0,0,SCREEN_W-1,SCREEN_H-1,UP);

    return 0;
}

int initGameCom() 
{ 
    gc=new GameCom;

    // Initialize it to use UDP port 12345, a segment size of 10, and threadbased mode
    if (gc->Initialize(PORT,10, true) != 0)
    {
        doError("Error setting up connection to network!");
    }   

    getString(buffer,server_address,-1,-1,4,20,"Done",
             "Enter the IP Address","of the Server, If you",
             "are the server then just","click Done!");

    // If we specified a host to connect to, add it as a peer 
    if (server_address[0]!='\0') 
    { 
        peer = gc->AddPeer(server_address, PORT); 
        if (peer==-1) 
        {     
            return -3; 
        } 
        else 
        { 
            strcpy(player[1].name,local_name);
            gc->QueueMessage(peer,GCOM_HELLO,local_name);
        } 
    }
    else
    {
        server=true;
        strcpy(player[0].name,local_name);
    }

    return 0;
}

