#include "main.h"

int rnd()
{
    return (_rnd = longrand(_rnd));
}

void srnd(unsigned long seed)
{
    _rnd = slongrand(seed);
}

int irnd()
{
    return (_irnd = longrand(_irnd));
}

void sirnd(unsigned long seed)
{
    _irnd = slongrand(seed);
}

#define RND_A 16807         /* multiplier */
#define RND_M 2147483647L   /* 2**31 - 1 */
//#define RND_Q 127773L       /* RND_M div RND_A */
//#define RND_R 2836          /* RND_M mod RND_A */

static long nextlongrand(long seed)
{
      unsigned long lo, hi;

      lo = RND_A * (long)(seed & 0xFFFF);
      hi = RND_A * (long)((unsigned long)seed >> 16);
      lo += (hi & 0x7FFF) << 16;
      if (lo > RND_M)
      {
            lo &= RND_M;
            ++lo;
      }
      lo += hi >> 15;
      if (lo > RND_M)
      {
            lo &= RND_M;
            ++lo;
      }
      return (long)lo;
}

long longrand(long randomnum)           /* return next random long */
{
      return nextlongrand(randomnum);
}

long slongrand(unsigned long seed)      /* to seed it */
{
      return (seed ? (seed & RND_M) : 1);   /* nonzero seed */
}

#undef RND_A
#undef RND_M