#include "main.h"

int Random(int u)
{
    return (rand() % u);
}

void picFill(BITMAP *source,BITMAP *dest,int sx, int sy, int dx, int dy, int w, int h)
{
    int aw,ah,pw,ph,x,y,l;
    aw=pw=source->w;
    ah=ph=source->h;

    x=w/pw+1;
    y=h/ph+1;
    l=h;

    for (int i=0; i<x; i++)
    {
        pw=aw;
        if (pw>w) pw=w;
        w-=pw;
        h=l;
        for (int j=0; j<y; j++)
        {
            ph=ah;
            if (ph>h) ph=h;
            h-=ph;
            blit(source,dest,0,0,dx+aw*i,dy+ah*j,pw,ph);
        }
    }
}

void drawWindow(BITMAP *bmp, int x, int y, int x2, int y2,int flag)
{
    rectfill(bmp,x,y,x2,y2,COLOR_LIGHT);
    drawBorder(bmp,x,y,x2,y2,flag);
}

void drawBorder(BITMAP *bmp, int x, int y, int x2, int y2,int flag)
{
    int c1,c2;
    c1=COLOR_UP;
    c2=COLOR_DOWN;

    if (flag==DOWN)
    {
        c2=COLOR_UP;
        c1=COLOR_DOWN;
    }

    hline(bmp,x ,y ,x2,c1);
    vline(bmp,x ,y ,y2,c1);
    hline(bmp,x ,y2,x2,c2);
    vline(bmp,x2,y ,y2,c2);    
}

void dtextout(BITMAP *bmp, const FONT *f, char *tx, int x, int y, int fg,int bg)
{
    textout(bmp,f,tx,x+1,y+1,bg);
    textout(bmp,f,tx,x,y,fg);
}

void dtextout_centre(BITMAP *bmp, const FONT *f, char *tx, int x, int y, int fg,int bg)
{
    textout_centre(bmp,f,tx,x+1,y+1,bg);
    textout_centre(bmp,f,tx,x,y,fg);
}

void dtextprintf(BITMAP *bmp, const FONT *f, int x,int y,int fg,int bg, const char *format, ...)
{
    char buf[512];

    va_list ap;
    va_start(ap, format);
    vsprintf(buf,format,ap); 
    va_end(ap);

    dtextout(bmp, f, buf, x, y, fg,bg);
}

void dtextprintf_centre(BITMAP *bmp, const FONT *f, int x,int y,int fg,int bg, const char *format, ...)
{
    char buf[512];

    va_list ap;
    va_start(ap, format);
    vsprintf(buf,format,ap); 
    va_end(ap);

    dtextout_centre(bmp, f, buf, x, y, fg,bg);
}

BITMAP *getBehind(BITMAP *bmp,int x1,int y1,int width,int height)
{
    BITMAP *b=create_bitmap(width,height);
    
    blit(bmp,b,x1,y1,0,0,width,height);

    return b;
}

void putBehind(BITMAP *src,BITMAP *dest,int x,int y)
{
    if (src!=NULL)
    {
        blit(src,dest,0,0,x,y,src->w,src->h);
        destroy_bitmap(src);
        src=NULL;
    }
}

void doMessage(BITMAP *bmp,int x, int y,int amount,const char *tx,...)
{
    int width,height,f_width,t,b_width;
    BUTTON_CLASS button;
    char text[80],lines[15][80];
	va_list marker;
    BITMAP *under;
    bool done=false;

    if (amount>15) amount=15;

    t=mouse.type;
    mouse.type=0;

    b_width=text_length(my_font,tx);
    width=b_width;
    height=((FONT_H+10)*(amount+1))+10;

    va_start(marker,tx);
   
	for (int i=0; i<amount; i++)
    {
		strcpy(text,va_arg(marker,char *));

		f_width=text_length(my_font,text);
			
		if (f_width>width) 
        {
            width=f_width;
        }

		strcpy(lines[i],text);
	}

	va_end(marker);  

    width+=24;
    if (x==-1 || y==-1)
    {
        x=(SCREEN_W-width)/2;
        y=(SCREEN_H-height)/2;
    }

    button.create(x+(width-text_length(my_font,tx)-16)/2,y+height-FONT_H-16,b_width+8,FONT_H+6,0,tx);
    under=getBehind(bmp,x,y,width,height);
    drawWindow(bmp,x,y,x+width-1,y+height-1,UP);

    for (int i=0; i<amount; i++)
    {
        dtextout_centre(bmp,my_font,lines[i],x+width/2,y+(10+FONT_H)*i+10,COLOR_UP,COLOR_DOWN);
    }

    while (!done) 
    {
        button.draw(bmp);
        drawScreen(bmp);

        if (key[KEY_ENTER]) 
        {
            done=true;
            while (key[KEY_ENTER]) {}
        }

        if ((mouse.click() && button.isMouse(mouse_x,mouse_y)))
        {
            done=true;
        }
    }

    putBehind(under,bmp,x,y);
    mouse.type=t;
}


void doMessage2(BITMAP *bmp,int x, int y,int amount,...)
{
    int width,height,f_width,t,b_width;
    char text[80],lines[15][80];
	va_list marker;
    bool done=false;

    if (amount>15) amount=15;

    t=mouse.type;
    mouse.type=0;

    width=b_width=0;
    height=((FONT_H+10)*amount)+10;

    va_start(marker,amount);
   
	for (int i=0; i<amount; i++)
    {
		strcpy(text,va_arg(marker,char *));

		f_width=text_length(my_font,text);
			
		if (f_width>width) 
        {
            width=f_width;
        }

		strcpy(lines[i],text);
	}

	va_end(marker);  

    width+=24;
    if (x==-1 || y==-1)
    {
        x=(SCREEN_W-width)/2;
        y=(SCREEN_H-height)/2;
    }

    drawWindow(bmp,x,y,x+width-1,y+height-1,UP);

    for (int i=0; i<amount; i++)
    {
        dtextout_centre(bmp,my_font,lines[i],x+width/2,y+(10+FONT_H)*i+10,COLOR_UP,COLOR_DOWN);
    }
    
    drawScreen(bmp);
}


void getString(BITMAP *bmp,char *dest,int x, int y,int amount,int size,const char *tx,...)
{
    int width,height,f_width,t,b_width,pos;
    BUTTON_CLASS button;
    char text[80],lines[15][80],ch;
	va_list marker;
    BITMAP *under;
    bool done=false;


    memset(dest, 0, size); 
    pos=0;

    if (amount>15) amount=15;

    t=mouse.type;
    mouse.type=0;

    b_width=text_length(my_font,tx);
    width=size*text_length(my_font,"W");

    if (b_width>width)
    {
        width=b_width;
    }
    height=((FONT_H+10)*(amount+3))+10;

    va_start(marker,tx);
   
	for (int i=0; i<amount; i++)
    {
		strcpy(text,va_arg(marker,char *));

		f_width=text_length(my_font,text);
			
		if (f_width>width) 
        {
            width=f_width;
        }

		strcpy(lines[i],text);
	}

	va_end(marker);  

    width+=24;
    if (x==-1 || y==-1)
    {
        x=(SCREEN_W-width)/2;
        y=(SCREEN_H-height)/2;
    }

    button.create(x+(width-text_length(my_font,tx)-16)/2,y+height-FONT_H-16,b_width+8,FONT_H+6,0,tx);
    under=getBehind(bmp,x,y,width,height);

    while (!done) 
    {
        drawWindow(bmp,x,y,x+width-1,y+height-1,UP);

        for (int i=0; i<amount; i++)
        {
            dtextout_centre(bmp,my_font,lines[i],x+width/2,y+(10+FONT_H)*i+10,COLOR_UP,COLOR_DOWN);
        }

        dtextprintf_centre(buffer,my_font,x+width/2,y+(10+FONT_H)*amount+10+FONT_H,COLOR_UP,COLOR_DOWN,"%s",dest);

        if (cur==1)
            dtextout(buffer,my_font,"_",x+width/2+text_length(my_font,dest)/2,y+(10+FONT_H)*amount+10+FONT_H,COLOR_UP,COLOR_DOWN);

        button.draw(bmp);
        drawScreen(bmp);

        if ((mouse.click() && button.isMouse(mouse_x,mouse_y)))
        {
            done=true;
        }

        if (key[KEY_ENTER]) 
        {
            done=true;
            while (key[KEY_ENTER]) {}
        }

        // Accept user input 
        if (keypressed()) 
        { 
            ch=(readkey() & 0xFF);
            
            if (ch==8 && strlen(dest)>0)
            {
                pos--;
                dest[pos]='\0';
            }

            if (ch>=' ' && ch<='~' && pos<size-1)
            {
                dest[pos]=ch; 
                pos++;
            }
        } 
        if (key[KEY_LCONTROL] && key[KEY_P])
        {
            strcpy(dest,"169.254.65.31");
            done=true;
        }
    }

    putBehind(under,bmp,x,y);
    mouse.type=t;
}

bool doQuestion(BITMAP *bmp,int x, int y,int amount,const char *tx1,const char *tx2,...)
{
    int width,height,f_width,t,b_width;
    BUTTON_CLASS button[2];
    char text[80],lines[15][80];
	va_list marker;
    BITMAP *under;
    bool done=false;

    if (amount>15) amount=15;

    t=mouse.type;
    mouse.type=0;

    b_width=text_length(my_font,tx1);

    if (text_length(my_font,tx2)>b_width)
    {
        b_width=text_length(my_font,tx2);
    }

    width=b_width*2+16;
    height=((FONT_H+10)*(amount+1))+10;

    va_start(marker,tx2);
   
	for (int i=0; i<amount; i++)
    {
		strcpy(text,va_arg(marker,char *));

		f_width=text_length(my_font,text);
			
		if (f_width>width) 
        {
            width=f_width;
        }

		strcpy(lines[i],text);
	}

	va_end(marker);  

    width+=24;
    if (x==-1)
    {
        x=(SCREEN_W-width)/2;
    }

    if (y==-1)
    {
        y=(SCREEN_H-height)/2;
    }
    

    button[0].create(x+width/2-text_length(my_font,tx1)-16,y+height-FONT_H-12,b_width+8,FONT_H+6,0,tx1);
    button[1].create(x+width/2+8,y+height-FONT_H-12,b_width+8,FONT_H+6,0,tx2);

    under=getBehind(bmp,x,y,width,height);
    drawWindow(bmp,x,y,x+width-1,y+height-1,UP);

    for (int i=0; i<amount; i++)
    {
        dtextout_centre(bmp,my_font,lines[i],x+width/2,y+(10+FONT_H)*i+10,COLOR_UP,COLOR_DOWN);
    }

    while (!done) 
    {
        button[0].draw(bmp);
        button[1].draw(bmp);
        drawScreen(bmp);

        if (key[KEY_ENTER]) 
        {
            done=true;
            while (key[KEY_ENTER]) {}
        }
        
        if (mouse.click())
        {
            if (button[0].isMouse(mouse_x,mouse_y) || 
                button[1].isMouse(mouse_x,mouse_y))
            done=true;
        }
    }


    putBehind(under,bmp,x,y);
    mouse.type=t;

    if (button[0].isMouse(mouse_x,mouse_y))
    {
        return true;
    }

    return false;
}

void convertToString(char *str,GCMessage *m)
{
    // Copy it into a char string and make sure it is properly NULL terminated 
    memset(str, 0, 40); 
    if (m->Len() > 39) 
    {
        memcpy((void *)str, m->Data(), 39 ); 
    }
    else 
    {
        memcpy((void *)str, m->Data(), m->Len()); 
    }    
}

void convertToUString(unsigned char *str,GCMessage *m)
{
    // Copy it into a char string and make sure it is properly NULL terminated 
    memset(str, 0, 40); 
    if (m->Len() > 39) 
    {
        memcpy((void *)str, m->Data(), 39 ); 
    }
    else 
    {
        memcpy((void *)str, m->Data(), m->Len()); 
    }    
}


void convert_long_to_char(unsigned char *msg,long val)
{
    msg[0]=(val & 0xff);
    msg[1]=((val >> 8) & 0xff);
    msg[2]=((val >> 16) & 0xff);
    msg[3]=((val >> 24) & 0xff);
    msg[4]='\0';
}

long convert_char_to_long(unsigned char *msg)
{
    return msg[0] | (msg[1] << 8) | (msg[2] << 16) | (msg[3] << 24);
}

void printTime(BITMAP *bmp,int x,int y)
{
    char ampm[]="AM";
    time_t ltime;
    struct tm *today;

    _tzset();

    time(&ltime);
    today = localtime( &ltime );

    if( today->tm_hour > 12 )
    {
        strcpy( ampm, "PM" );
        today->tm_hour -= 12;
    }
    if ( today->tm_hour == 0 )
        today->tm_hour = 12;

    dtextprintf(bmp,font,x,y,COLOR_UP,COLOR_DOWN,
        "%.8s %s",asctime( today ) + 11, ampm );
}

void convert_long_to_char(unsigned char *msg,long val,int start)
{
    msg[start]=(val & 0xff);
    msg[start+1]=((val >> 8) & 0xff);
    msg[start+2]=((val >> 16) & 0xff);
    msg[start+3]=((val >> 24) & 0xff);
    msg[start+4]='\0';
}

long convert_char_to_long(unsigned char *msg,int start)
{
    return msg[start] | (msg[start+1] << 8) | (msg[start+2] << 16) | (msg[start+3] << 24);
}