#include <allegro.h>
#include <winalleg.h>
#include <gamecom.h>
#include <stdio.h>
#include <time.h>
#include "data.h"

// lib settings alleg.lib gclib.lib ws2_32.lib 

#define for if(false) {} else for

#define PORT                8765

#define MAX_MESSAGE         6

#define TYPE_PEER       1
#define TYPE_SOLO       0

#define GCOM_HELLO          1
#define GCOM_HELLO_REPLY    2
#define GCOM_GET_SEED       3
#define GCOM_MOVE           4
#define GCOM_MESSAGE        5
#define GCOM_NEW_GAME       6
#define GCOM_SEND_CHAT      7
#define GCOM_LAUGH          8
#define GCOM_MOUSE          9
#define GCOM_QUIT           999

#define INPUT_UP            1
#define INPUT_DOWN          2
#define INPUT_LEFT          4
#define INPUT_RIGHT         8
#define INPUT_SPACE         16


#define UP                  0
#define DOWN                1
#define LEFT                2
#define RIGHT               3

#define COLOR_UP            15
#define COLOR_LIGHT         7
#define COLOR_DOWN          8

class BUTTON_CLASS
{
public:
    int x_pos;
    int y_pos;
    int width;
    int height;
    int flag;
    char text[100];
    BITMAP *sprite;

    void create(int x, int y, int w, int h, int f,const char *tx);
    void create(int x, int y, int w, int h, int f,BITMAP *bmp);
    void draw(BITMAP *bmp);
    bool isMouse(int x, int y);
};

class MOUSE_CLASS
{
public:
    bool down;
    bool hide;
    int type;
    BITMAP *under;

    void Hide();
    void Show();
    void init();
    void uninit();
    bool click();
    void update();
    void draw(BITMAP *bmp);
    void change(int t);
};


class TEXT_CLASS
{
public:
    int pos;
    char text[MAX_MESSAGE][40];
    void clear();
    void addMessage(char *str);
    void draw(BITMAP *bmp,int x,int y);
};

class BOARD_CLASS
{
public:
    int grid[6][7];
    bool winner;
    void clear();
    void draw(BITMAP *bmp);
    void place(int x,int c);
    bool isWinner(int x,int y,int c,int dir,int p);
};

class PLAYER_CLASS
{
public:
    char name[40];
};

typedef struct D_POINT
{
    int x;
    int y;
} D_POINT;

extern BITMAP *buffer;
extern volatile int cur;
extern FONT *my_font;
extern DATAFILE *data;
extern GameCom *gc;
extern MOUSE_CLASS mouse;
extern PLAYER_CLASS player[2];
extern int FONT_H;
extern char local_name[40];
extern bool server;
extern int peer;
extern int p_local;
extern int p_net;
extern int turn;
extern unsigned char packet[40];
extern char chat_string[40];
extern TEXT_CLASS chat_list[2];
extern BOARD_CLASS board;
extern D_POINT m2;

/******************** main.cpp **************************/
void doError(AL_CONST char *msg, ...);
int initAll();

void deleteAll();
void drawAll();
void drawScreen(BITMAP *bmp);
int main();

/******************** gcom.cpp **************************/
int initGameCom();
int waitForPeer();

/******************** game.cpp **************************/
void doGame(int type);

/******************** misc.cpp **************************/
int Random(int u);
void picFill(BITMAP *source,BITMAP *dest,int sx, int sy, int dx, int dy, int w, int h);
void drawWindow(BITMAP *bmp, int x, int y, int x2, int y2,int flag);
void drawBorder(BITMAP *bmp, int x, int y, int x2, int y2,int flag);
void dtextout(BITMAP *bmp, const FONT *f, char *tx, int x, int y, int fg,int bg);
void dtextout_centre(BITMAP *bmp, const FONT *f, char *tx, int x, int y, int fg,int bg);
void dtextprintf(BITMAP *bmp, const FONT *f, int x,int y,int fg,int bg, const char *format, ...);
void dtextprintf_centre(BITMAP *bmp, const FONT *f, int x,int y,int fg,int bg, const char *format, ...);

BITMAP *getBehind(BITMAP *bmp,int x1,int y1,int x2,int y2);
void putBehind(BITMAP *src,BITMAP *dest,int x,int y);

void doMessage(BITMAP *bmp,int x, int y,int amount,const char *tx,...);
void doMessage2(BITMAP *bmp,int x, int y,int amount,...);
bool doQuestion(BITMAP *bmp,int x, int y,int amount,const char *tx1,const char *tx2,...);
void getString(BITMAP *bmp,char *dest,int x, int y,int amount,int size,const char *tx,...);

void doGameHelp();
void convert_long_to_char(unsigned char *msg,long val);
long convert_char_to_long(unsigned char *msg);
void convertToString(char *str,GCMessage *m);
void convertToUString(unsigned char *str,GCMessage *m);
void convert_long_to_char(unsigned char *msg,long val,int start);
long convert_char_to_long(unsigned char *msg,int start);

void printTime(BITMAP *bmp,int x,int y);
/******************** rnd.cpp **************************/

#ifndef __INCLUDED_MY_HEADERFILE
#define __INCLUDED_MY_HEADERFILE
static long _rnd;
static long _irnd;
extern long seed;
#endif

int rnd();
void srnd(unsigned long seed);
int irnd();
void sirnd(unsigned long seed);
static long nextlongrand(long seed);
long longrand(long randomnum);
long slongrand(unsigned long seed);
