#include "main.h"

void doGame(int type)
{
    bool done=false;
    char buf[40],ch;
    GCMessage *m;
    int p,pcol[2]={12,10};
    int mx,my;
    BUTTON_CLASS button[3];

    mx=my=0;

    button[0].create(568,250,70,32,0,"New Game");
    button[1].create(568,290,70,32,0,(BITMAP*)data[B_SOUND].dat);
    button[2].create(568,330,70,32,0,"Quit");

    if (type==TYPE_PEER)
    {
        getString(buffer,local_name,-1,-1,1,38,"Done","Enter your name:");

        if (initGameCom()!=0)
        {
            doError("There was an error connecting\nyou to the sockets!");
        }

        p=waitForPeer();
    
        if (p!=0)
        {
            if (p==-2)
            {
                doError("There was an error waiting\nfor a peer to connect!");                
            }
            return;
        }
    }
    else
    {
        p_local=0;
        p_net=1;
        getString(buffer,player[0].name,-1,-1,1,38,"Done","Player 1, Enter your name:");
        getString(buffer,player[1].name,-1,-1,1,38,"Done","Player 2, Enter your name:");
    }

    board.clear();

    // start of game loop

    while (!done)
    {
        clear_bitmap(buffer);

        // whole screen
        drawWindow(buffer,0,0,SCREEN_W,SCREEN_H,UP);

        // game area
        drawWindow(buffer,3,3,565,365,DOWN);

        board.draw(buffer);

        // chat box
        drawWindow(buffer,128,SCREEN_H-108,SCREEN_W-129,SCREEN_H-92,DOWN);
        if (mouse_x>=128 && mouse_x<=SCREEN_W-129 && cur==1 &&
            mouse_y>=SCREEN_H-108 && mouse_y<=SCREEN_H-92)
        {
            dtextprintf(buffer,font,132,SCREEN_H-100-text_height(font)/2,COLOR_UP,COLOR_DOWN,"Chat: %s_",chat_string);
        }
        else
        {
            dtextprintf(buffer,font,132,SCREEN_H-100-text_height(font)/2,COLOR_UP,COLOR_DOWN,"Chat: %s",chat_string);
        }


        // left and right chat outputs
        drawWindow(buffer,3,SCREEN_H-88,SCREEN_W/2-2,SCREEN_H-20,DOWN);
        drawWindow(buffer,SCREEN_W/2,SCREEN_H-88,SCREEN_W-4,SCREEN_H-20,DOWN);

        dtextout(buffer,font,player[0].name,6,SCREEN_H-100-text_height(font)/2,pcol[0],0);
        dtextout(buffer,font,player[1].name,SCREEN_W-7-text_length(font,player[1].name),SCREEN_H-100-text_height(font)/2,pcol[1],0);

        chat_list[0].draw(buffer,5,SCREEN_H-85);
        chat_list[1].draw(buffer,SCREEN_W/2+2,SCREEN_H-85);

        dtextout(buffer,font,"NetFour",6,SCREEN_H-14,10,0);
        printTime(buffer,SCREEN_W-100,SCREEN_H-14);

        if (!board.winner)
        {
            circlefill(buffer,SCREEN_W-36,100,20,pcol[turn]);
        }

        button[0].draw(buffer);
        button[1].draw(buffer);
        button[2].draw(buffer);

        if (type==TYPE_PEER)
        {
            draw_sprite(buffer,(BITMAP*)data[MY_MOUSE].dat,m2.x,m2.y);
        }

        drawScreen(buffer);

        if (keypressed())
        {
            if (mouse_x>=128 && mouse_x<=SCREEN_W-129 &&
                mouse_y>=SCREEN_H-108 && mouse_y<=SCREEN_H-92)
            {
                ch=readkey() & 0xff;

	            if (ch==8 && strlen(chat_string)>0 )
		    	{
			    	strcpy(buf,"");
				    strncat(buf, chat_string, strlen(chat_string)-1);
				    strcpy(chat_string,buf);
			    }

		
		        if (strlen(chat_string)<39) 
			    {	
				    if (ch>=' ' && ch<='~')
				    {
    					sprintf(chat_string,"%s%c",chat_string,ch);
				    }
			    }

                if (ch==13)
                {
                    chat_list[p_local].addMessage(chat_string);
                    if (type==TYPE_PEER)
                    {
                        gc->QueueMessage(peer,GCOM_SEND_CHAT,chat_string);
                    }
                    strcpy(chat_string,"");
                }
            }
            else
            {
                clear_keybuf();
            }
		}

        if (type==TYPE_PEER)
        {
            if (mouse_x!=mx || mouse_y!=my)
            {
                mx=mouse_x;
                my=mouse_y;
                convert_long_to_char(packet,mx,0);
                convert_long_to_char(packet,my,4);
                gc->QueueMessage(peer,GCOM_MOUSE,(void*)packet,40);
            }
        }
            
        if (mouse.click())
        {
            if (mouse_x>3 && mouse_y>4 && mouse_x<566 && mouse_y<366 && !board.winner)
            {
                int x=(mouse_x-4)/80;
                if (board.grid[0][x]<0)
                {
                    if (type==TYPE_PEER)
                    {
                        if (turn==p_local)
                        {
                            board.place(x,p_local);
                            packet[0]=x;
                            packet[1]='\0';
                            gc->QueueMessage(peer,GCOM_MOVE,(void*)packet,40);
                            turn=p_net;
                        }
                    }
                    else
                    {
                        board.place(x,turn);
                        turn++;
                        if (turn>1) turn=0;
                    }
                }
            }
            if (button[0].isMouse(mouse_x,mouse_y))
            {
                if (doQuestion(buffer,-1,-1,2," Yes ","No",
                        "Are you sure that you",
                        "want to start a new game?"))
                {
                    if (type==TYPE_PEER)
                    {
                        gc->QueueMessage(peer,GCOM_NEW_GAME,0);
                    }
                    board.clear();
                    turn=0;
                }          
            }
            if (button[1].isMouse(mouse_x,mouse_y))
            {
                play_sample((SAMPLE*)data[SAMPLE01].dat,128,128,1000,FALSE);
                if (type==TYPE_PEER)
                {
                    gc->QueueMessage(peer,GCOM_LAUGH,0);
                }
            }
            if (button[2].isMouse(mouse_x,mouse_y))
            {
                if (doQuestion(buffer,-1,-1,2," Yes ","No",
                        "Are you sure that you",
                        "want to end your game?"))
                {
                    if (type==TYPE_PEER)
                    {
                        gc->QueueMessage(peer,GCOM_QUIT,0);
                    }
                    done=true;
                }          
            }
        }

        if (key[KEY_ESC]) 
        {
            while (key[KEY_ESC]) {}
            if (doQuestion(buffer,-1,-1,2," Yes ","No",
                    "Are you sure that you",
                    "want to end your game?"))
            {
                if (type==TYPE_PEER)
                {
                    gc->QueueMessage(peer,GCOM_QUIT,0);
                }
                done=true;
            }
        }

        if (type==TYPE_PEER)
        {
            while ((m = gc->GetMessage()) != NULL) 
            { 
                if (m->Channel()==GCOM_QUIT)
                {
                    char msg[40];
                    mouse.Show();
                    sprintf(msg,"%s has left the game!",player[p_net].name);
                    doMessage(buffer,-1,-1,1,"Ok",msg);
                    done=true;
                }

                if (m->Channel()==GCOM_SEND_CHAT)
                {         
                    char msg[40];
                    convertToString(msg,m);
                    chat_list[p_net].addMessage(msg);
                }
                if (m->Channel()==GCOM_MOVE)
                {         
                    convertToUString(packet,m);
                    board.place(packet[0],p_net);
                    turn=p_local;
                }
                if (m->Channel()==GCOM_NEW_GAME)
                {         
                    board.clear();
                    turn=0;
                }
                if (m->Channel()==GCOM_LAUGH)
                {   
                    play_sample((SAMPLE*)data[SAMPLE01].dat,128,128,1000,FALSE);
                }
                if (m->Channel()==GCOM_MOUSE)
                {         
                    convertToUString(packet,m);                                      
                    m2.x=convert_char_to_long(packet,0);
                    m2.y=convert_char_to_long(packet,4);
                }
            }
        }
    }


    // end of game loop;
    if (type==TYPE_PEER)
    {
        delete gc;
    }

    clear_bitmap(buffer);
}

