#include "main.h"


void BOARD_CLASS::clear()
{
    for (int i=0; i<7; i++)
    {
        for (int j=0; j<6; j++)
        {
            grid[j][i]=-1;
        }
    }
    winner=false;
}

void BOARD_CLASS::draw(BITMAP *bmp)
{
    for (int i=0; i<7; i++)
    {
        for (int j=0; j<6; j++)
        {
            if (winner && cur==1 && grid[j][i]>=0 && grid[j][i]!=turn)
            {
                blit((BITMAP*)data[SQUARE003+grid[j][i]].dat,bmp,0,0,4+i*80,4+j*60,80,60);
            }
            else
            {
                blit((BITMAP*)data[SQUARE000+grid[j][i]+1].dat,bmp,0,0,4+i*80,4+j*60,80,60);
            }
        }
    }
}

void BOARD_CLASS::place(int x,int c)
{

    int y=0;

    while (y<5 && grid[y+1][x]<0)
    {
        y++;
    }

    grid[y][x]=c;

    for (int i=0; i<3; i++)
    {
        switch (i)
        {
        case 0:
            {
                while (y<5 && grid[y+1][x]==c)
                {
                    y++;
                }
                if (isWinner(x,y,c,i,0)) 
                {
                    winner=true;
                    return;
                }
            } 
            break;
        case 1:
            {
                while (x<6 && grid[y][x+1]==c)
                {
                    x++;
                }
                if (isWinner(x,y,c,i,0)) 
                {
                    winner=true;
                    return;
                }
            }
            break;
        case 2:
            {
                while (x<6 && y<5 && grid[y+1][x+1]==c)
                {
                    x++;y++;
                }
                if (isWinner(x,y,c,i,0)) 
                {
                    winner=true;
                    return;
                }
            }
            break;
        case 3:
            {
                while (x<6 && y>0 && grid[y-1][x+1]==c)
                {
                    x++;y--;
                }
                if (isWinner(x,y,c,i,0)) 
                {
                    winner=true;
                    return;
                }
            }
            break;
        }    
    }
  
}

bool BOARD_CLASS::isWinner(int x,int y,int c,int dir,int p)
{
    if (p==3) return true;

    switch (dir)
    {
    case 0:
        {
            if (y>0 && grid[y-1][x]==c)
            {
                return isWinner(x,y-1,c,dir,p+1);
            }
        } 
        break;
    case 1:
        {
            if (x>0 && grid[y][x-1]==c)
            {
                return isWinner(x-1,y,c,dir,p+1);
            } 
        }
        break;
    case 2:
        {
            if (y>0 && x>0 && grid[y-1][x-1]==c)
            {
                return isWinner(x-1,y-1,c,dir,p+1);
            } 
        }
        break;
    case 3:
        {
            if (y<5 && x>0 && grid[y+1][x-1]==c)
            {
                return isWinner(x-1,y+1,c,dir,p+1);
           }
        }
        break;
    }

    return false;
}