#include <allegro.h>
#include <stdio.h>
#include <fstream.h>
#include <time.h>
#include <dlgraph.h>

#include "data.h"
#include "pdata.h"

#define GAME_TITLE		"Jigsaw Puzzle"

#define MALE			1
#define FMALE			2

#define S_SMALL			0
#define S_NORMAL		1
#define S_LARGE			2

#define LU				20
#define LD				380
#define LL				20
#define LR				574

extern USHORT grp;
extern bool pr;
extern USHORT my_choice;

extern 	DATAFILE *data,*pdata1,*pdata2,*pdata3;	

typedef struct DPiece
{
	BITMAP *sprite;
	USHORT x,y;
	USHORT pn[4];
	USHORT type[4];
	bool con[4];
	USHORT Group;
} DPiece;

class PUZZLE_STAT
{
public:
	void Set_Size(BITMAP *,int);
	int m_W();
	int m_H();
	int m_w();
	int m_h();
	int PUZZLE_W;
	int PUZZLE_H;
	int MAX_PIECE;
	USHORT m_choice;
};

class DPuzzle
{
public:
	void New_Puzzle(int,int);
	void Init();
	void Draw(BITMAP*);
	void Delete();
	void make_stencil(BITMAP *bmp,BITMAP *stencil);
	void convert_black(BITMAP* bmp);
	DPiece Piece[400];
	PUZZLE_STAT  PUZ;
	BITMAP *puzzle_bitmap;
	DATAFILE *my_data;
};

typedef struct SEL
{
	int n;
	int x,y;
} SEL;

class DGame
{
public:
	void Grab_Piece();
	void Let_Go();
	void Init_All();
	void Draw_All();
	void Delete_All();
	int Which_Button();
	void Program();
	void Move();
	void Move(int,int,int);
	void Group(int,int);
	int Pick();
	bool Game_Over();
	BITMAP *mbit;
	DMenu Menu;
	PopupStruct Pop;
	DPuzzle Puzzle;
	SEL SPiece;
};

int main();
void play_sound(int s);
