#include "main.h"

int cc=makecol(200,200,101);

void DPuzzle::make_stencil(BITMAP *bmp,BITMAP *stencil)
{
	int i,j,p;
	
	for (i=0; i<PUZ.m_W(); i++)
	{
		for (j=0; j<PUZ.m_H(); j++)
		{
			p=getpixel(stencil,i,j);
			if (p!=COLOR_TRANS)
			{
				putpixel(bmp,i,j,cc);
			}
		}
	}	
}

void DPuzzle::convert_black(BITMAP* bmp)
{
	int i,j;
	for (i=0; i<bmp->w; i++)
	{
		for (j=0; j<bmp->h; j++)
		{
			if (getpixel(bmp,i,j)==cc)
			{
				putpixel(bmp,i,j,COLOR_TRANS);
			}
		}
	}
}

void DPuzzle::New_Puzzle(int ss,int puz)
{
	BITMAP *stencil;
	int i,j,p=0,k,w,h;

	char fname[5][40]={"puzzle01.bmp","puzzle02.bmp","puzzle03.bmp",
				  "puzzle04.bmp","puzzle05.bmp"};
	puzzle_bitmap=load_bmp(fname[puz],NULL);

	PUZ.Set_Size(puzzle_bitmap,ss);

	if (PUZ.m_choice==S_SMALL) 
	{
		my_data=pdata1;
	}
	if (PUZ.m_choice==S_NORMAL) 
	{
		my_data=pdata2;
	}
	if (PUZ.m_choice==S_LARGE) 
	{
		my_data=pdata3;
	}



	stencil=create_bitmap(PUZ.m_W(),PUZ.m_H());

	for (i=0; i<400; i++)
	{
		clear_to_color(Piece[i].sprite,cc);
	}


	if (PUZ.m_choice==S_SMALL)
	{
		w=6;
		h=6;
	}
	if (PUZ.m_choice==S_NORMAL)
	{
		w=8;
		h=8;
	}
	if (PUZ.m_choice==S_LARGE)
	{
		w=12;
		h=12;
	}


	for (i=0; i<PUZ.PUZZLE_W; i++)
	{
		for (j=0; j<PUZ.PUZZLE_H; j++)
		{
			Piece[p].x=Random(482)+48;
			Piece[p].y=Random(272)+48;

			Piece[p].type[0]=0;
			Piece[p].type[1]=0;
			Piece[p].type[2]=0;
			Piece[p].type[3]=0;	

		
			Piece[p].pn[0]=999;	
			Piece[p].pn[1]=999;	
			Piece[p].pn[2]=999;	
			Piece[p].pn[3]=999;	

			Piece[p].con[0]=false;
			Piece[p].con[1]=false;
			Piece[p].con[2]=false;
			Piece[p].con[3]=false;

			Piece[p].Group=0;		
	
			if (i<PUZ.PUZZLE_W-1)
			{
				k=Random(2)+MALE;
				Piece[p].type[RIGHT]=k;
				Piece[p].pn[RIGHT]=p+PUZ.PUZZLE_H;

			}
			if (j<PUZ.PUZZLE_H-1)
			{
				k=Random(2)+MALE;
				Piece[p].type[DOWN]=k;
				Piece[p].pn[DOWN]=p+1;

			}
			if (i>0)
			{
				k=Piece[p-PUZ.PUZZLE_H].type[RIGHT];
				Piece[p].pn[LEFT]=p-PUZ.PUZZLE_H;
				if (k==MALE)
					Piece[p].type[LEFT]=FMALE;
				else
					Piece[p].type[LEFT]=MALE;
			}
			if (j>0)
			{
				k=Piece[p-1].type[DOWN];
				Piece[p].pn[UP]=p-1;
				if (k==MALE)
					Piece[p].type[UP]=FMALE;
				else
					Piece[p].type[UP]=MALE;
			}
			blit(puzzle_bitmap,Piece[p].sprite,i*PUZ.m_w()-w,j*PUZ.m_h()-h,0,0,PUZ.m_W(),PUZ.m_H());
			p++;
			
		}
	}

	for (i=0; i<PUZ.MAX_PIECE; i++)
	{

		if (Piece[i].type[UP]==0)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RN1].dat);
		if (Piece[i].type[DOWN]==0)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RN2].dat);
		if (Piece[i].type[LEFT]==0)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RN3].dat);
		if (Piece[i].type[RIGHT]==0)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RN4].dat);

		if (Piece[i].type[UP]==MALE)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RM1].dat);
		if (Piece[i].type[DOWN]==MALE)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RM2].dat);
		if (Piece[i].type[LEFT]==MALE)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RM3].dat);
		if (Piece[i].type[RIGHT]==MALE)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RM4].dat);

		if (Piece[i].type[UP]==FMALE)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RF1].dat);
		if (Piece[i].type[DOWN]==FMALE)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RF2].dat);
		if (Piece[i].type[LEFT]==FMALE)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RF3].dat);
		if (Piece[i].type[RIGHT]==FMALE)
			make_stencil(Piece[i].sprite,(BITMAP*)my_data[RF4].dat);
		convert_black(Piece[i].sprite);
	}

	destroy_bitmap(stencil);

}

void DPuzzle::Init()
{
	int i;
	for (i=0; i<400; i++)
	{
		Piece[i].sprite=create_bitmap(64,64);
	}	
}

void DPuzzle::Draw(BITMAP *bmp)
{
	int i,j,f=0;
	clear(bmp);
	if (pr) blit(puzzle_bitmap,bmp,0,0,320-puzzle_bitmap->w/2,200-puzzle_bitmap->h/2,puzzle_bitmap->w,puzzle_bitmap->h);
	for (j=0; j<PUZ.MAX_PIECE; j++)
	{
		f=MAX(Piece[j].Group,f);
	}
	f++;

	for (j=0; j<f; j++)
	{
		for (i=0; i<PUZ.MAX_PIECE; i++)
		{
			if (Piece[i].Group==j)
			{
			draw_sprite(bmp,Piece[i].sprite,Piece[i].x,Piece[i].y);
			if (Piece[i].type[UP]==0 && Piece[i].con[UP]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LN1].dat,Piece[i].x,Piece[i].y);
			if (Piece[i].type[DOWN]==0 && Piece[i].con[DOWN]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LN2].dat,Piece[i].x,Piece[i].y);
			if (Piece[i].type[LEFT]==0 && Piece[i].con[LEFT]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LN3].dat,Piece[i].x,Piece[i].y);
			if (Piece[i].type[RIGHT]==0 && Piece[i].con[RIGHT]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LN4].dat,Piece[i].x,Piece[i].y);
	
			if (Piece[i].type[UP]==MALE && Piece[i].con[UP]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LM1].dat,Piece[i].x,Piece[i].y);
			if (Piece[i].type[DOWN]==MALE && Piece[i].con[DOWN]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LM2].dat,Piece[i].x,Piece[i].y);
			if (Piece[i].type[LEFT]==MALE && Piece[i].con[LEFT]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LM3].dat,Piece[i].x,Piece[i].y);
			if (Piece[i].type[RIGHT]==MALE && Piece[i].con[RIGHT]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LM4].dat,Piece[i].x,Piece[i].y);
	
			if (Piece[i].type[UP]==FMALE && Piece[i].con[UP]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LF1].dat,Piece[i].x,Piece[i].y);
			if (Piece[i].type[DOWN]==FMALE && Piece[i].con[DOWN]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LF2].dat,Piece[i].x,Piece[i].y);
			if (Piece[i].type[LEFT]==FMALE && Piece[i].con[LEFT]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LF3].dat,Piece[i].x,Piece[i].y);
			if (Piece[i].type[RIGHT]==FMALE && Piece[i].con[RIGHT]==false)
				draw_sprite(bmp,(BITMAP*)my_data[LF4].dat,Piece[i].x,Piece[i].y);
			}
		}
	}
}

void DPuzzle::Delete()
{
	int i;
	for (i=0; i<400; i++)
	{
		destroy_bitmap(Piece[i].sprite);
	}
	destroy_bitmap(puzzle_bitmap);
}