#include "main.h"

int ox,oy;
int W_Y,pp;
USHORT grp=0;
bool pr=false;


void play_sound(int s)
{
	play_sample((SAMPLE*)data[s].dat, 128, 128, 1000,FALSE);
}

void DGame::Grab_Piece()
{
	int i,px,py;
	ox=mouse_x;
	oy=mouse_y-W_Y;
	if (SPiece.n==999)
	{
		for (i=0; i<Puzzle.PUZ.MAX_PIECE; i++)
		{
			if (ox>=Puzzle.Piece[i].x &&
				ox<=Puzzle.Piece[i].x+Puzzle.PUZ.m_W() &&
				oy>=Puzzle.Piece[i].y &&
			    oy<=Puzzle.Piece[i].y+Puzzle.PUZ.m_H())
			{
				px=ox-Puzzle.Piece[i].x;
				py=oy-Puzzle.Piece[i].y;
				if (getpixel(Puzzle.Piece[i].sprite,px,py)!=COLOR_TRANS)
				{					
					SPiece.n=i;
					SPiece.x=px;
					SPiece.y=py;
				}
			}
		}
	}
}	
void DGame::Group(int s,int k)
{
	int l,o,j,f=0,m,m1,m2,kx=0,ky=0;
	for (j=0; j<Puzzle.PUZ.MAX_PIECE; j++)
	{
		f=MAX(Puzzle.Piece[j].Group,f);
	}
	f++;
	o=Puzzle.Piece[s].Group;
	l=Puzzle.Piece[k].Group;
	m1=o;
	m2=l;
	if (m1==0) m1=100;
	if (m2==0) m2=100;
	if (o==0 && l==0)
	{
		m=f;
	}
	if (o==0 && l!=0)
	{
		m=l;
	}
	if (o!=0 && l==0)
	{
		m=o;
	}
	if (o!=0 && l!=0)
	{
		m=MIN(o,l);
	}

	for (j=0; j<Puzzle.PUZ.MAX_PIECE; j++)
	{
		if (Puzzle.Piece[j].Group==m1 || Puzzle.Piece[j].Group==m2)
		{
			Puzzle.Piece[j].Group=m;
		}
		Puzzle.Piece[s].Group=m;
		Puzzle.Piece[k].Group=m;

	}
	for (j=0; j<Puzzle.PUZ.MAX_PIECE; j++)
	{
		if (Puzzle.Piece[j].Group==m)
		{
			if (Puzzle.Piece[j].x<LL)
				kx=Puzzle.Piece[j].x-LL;
			if (Puzzle.Piece[j].x>LR)
				kx=Puzzle.Piece[j].x-LR;

			if (Puzzle.Piece[j].y<LU)
				ky=Puzzle.Piece[j].y-LU;
			if (Puzzle.Piece[j].y>LD)
				ky=Puzzle.Piece[j].y-LD;
		}
	}
	for (j=0; j<Puzzle.PUZ.MAX_PIECE; j++)
	{
		if (Puzzle.Piece[j].Group==m)
		{
			Puzzle.Piece[j].x-=kx;
			Puzzle.Piece[j].y-=ky;
		}
	}
}

void DGame::Let_Go()
{
	int s,k,i;
	ox=0;
	oy=W_Y;

	if (SPiece.n!=999)
	{
		for (i=0; i<Puzzle.PUZ.MAX_PIECE; i++)
		{
			s=i;
			k=Puzzle.Piece[s].pn[RIGHT];
			if (k!=999)
			{
				if (ABS(Puzzle.Piece[s].y-Puzzle.Piece[k].y)<10)
				{
					if (ABS(Puzzle.Piece[s].x-(Puzzle.Piece[k].x-+Puzzle.PUZ.m_w()))<10)
					{
							if (Puzzle.Piece[s].con[RIGHT]==false)
								play_sound(SOUND2);
						Puzzle.Piece[s].con[RIGHT]=true;
						Puzzle.Piece[k].con[LEFT]=true;
						Move(s,Puzzle.Piece[k].x-Puzzle.PUZ.m_w(),Puzzle.Piece[k].y);
						Group(s,k);
					}
				}
			}
			k=Puzzle.Piece[s].pn[LEFT];
			if (k!=999)
			{
				if (ABS(Puzzle.Piece[s].y-Puzzle.Piece[k].y)<10)
				{
					if (ABS(Puzzle.Piece[s].x-(Puzzle.Piece[k].x+Puzzle.PUZ.m_w()))<10)
					{
						if (Puzzle.Piece[s].con[LEFT]==false)
							play_sound(SOUND2);
						Puzzle.Piece[s].con[LEFT]=true;
						Puzzle.Piece[k].con[RIGHT]=true;
						Move(s,Puzzle.Piece[k].x+Puzzle.PUZ.m_w(),Puzzle.Piece[k].y);
						Group(s,k);
					}
				}
			}
			k=Puzzle.Piece[s].pn[DOWN];
			if (k!=999)
			{
				if (ABS(Puzzle.Piece[s].x-Puzzle.Piece[k].x)<10)
				{
					if (ABS(Puzzle.Piece[s].y-(Puzzle.Piece[k].y-Puzzle.PUZ.m_w()))<10)
					{
						if (Puzzle.Piece[s].con[DOWN]==false)
							play_sound(SOUND2);
						Puzzle.Piece[s].con[DOWN]=true;
						Puzzle.Piece[k].con[UP]=true;
						Move(s,Puzzle.Piece[k].x,Puzzle.Piece[k].y-Puzzle.PUZ.m_w());
						Group(s,k);
					}
				}
			}
			k=Puzzle.Piece[s].pn[UP];
			if (k!=999)
			{
				if (ABS(Puzzle.Piece[s].x-Puzzle.Piece[k].x)<10)
				{
					if (ABS(Puzzle.Piece[s].y-(Puzzle.Piece[k].y+Puzzle.PUZ.m_w()))<10)
					{
						if (Puzzle.Piece[s].con[UP]==false)
							play_sound(SOUND2);
						Puzzle.Piece[s].con[UP]=true;
						Puzzle.Piece[k].con[DOWN]=true;
						Move(s,Puzzle.Piece[k].x,Puzzle.Piece[k].y+Puzzle.PUZ.m_w());
						Group(s,k);
					}
				}
			}
		}
	}	
	SPiece.n=999;
}	

void DGame::Init_All()
{
	Pop.Create("New Game","---","Quit",END);

	install_d_font((FONT*)data[FONT1].dat);

	/*
	COLOR_TITLE			=	1;
	COLOR_TOP			=	2;
	COLOR_LIGHT			=	3;
	COLOR_DARK			=	4;
	COLOR_BOTTOM		=	5;
	
	COLOR_TEXT_UP		=	2;
	COLOR_TEXT_DOWN		=	5;

	MOUSE_WHITE			=	2;
	MOUSE_BLACK			=	5;

	*/



	game_name("Jigsaw Puzzle");

	text_mode(-1);
	Mouse.Show();

	Menu.Create(2,BOTTOM_OF_TITLE+2,true,"File","Preview","About","@@@");

	Title_Window(Screen,NULL,0,0,SCREEN_W,SCREEN_H,GAME_TITLE);

	mbit=create_bitmap(SCREEN_W-5,SCREEN_H-(2*BOTTOM_OF_TITLE)-7);
	clear(mbit);
	Puzzle.Init();
	SPiece.n=999;
	ox=oy=0;
}

void DGame::Move(int s,int kx,int ky)
{
	int i,k,x,y,px,py;
	x=kx-Puzzle.Piece[s].x;
	y=ky-Puzzle.Piece[s].y;
	
	px=py=0;
	
	k=Puzzle.Piece[s].Group;
	if (k==0)
	{
		Puzzle.Piece[s].x+=x;
		Puzzle.Piece[s].y+=y;
	}
	else
	{
		for (i=0; i<Puzzle.PUZ.MAX_PIECE; i++)
		{
			if (Puzzle.Piece[i].Group==k)
			{
				Puzzle.Piece[i].x+=x;
				Puzzle.Piece[i].y+=y;
			}
		}
	}
}

void DGame::Move()
{
	int i,k,p,x,y,j,l=0,kx=0,ky=0,lx,ly;

	lx=mouse_x;
	ly=mouse_y;
	if (lx<LL) lx=LL;
	if (lx>LR) lx=LR;
	if (ly<W_Y+LU) ly=W_Y+LU;
	if (ly>W_Y+LD) ly=W_Y+LD;

	x=lx-ox;
	y=ly-W_Y-oy;
	if (x<-20) x=-20;
	if (x>20) x=20;
	if (y<-20) y=-20;
	if (y>20) y=20;
		
	p=SPiece.n;
	k=Puzzle.Piece[p].Group;

	if (k==0)
	{
		Puzzle.Piece[p].x+=x;
		Puzzle.Piece[p].y+=y;
		if (Puzzle.Piece[p].x<LL)
			Puzzle.Piece[p].x=LL;
		if (Puzzle.Piece[p].x>LR)
			Puzzle.Piece[p].x=LR;
		if (Puzzle.Piece[p].y<LU)
			Puzzle.Piece[p].y=LU;
		if (Puzzle.Piece[p].y>LD)
			Puzzle.Piece[p].y=LD;
	}
	else
	{
		for (i=0; i<Puzzle.PUZ.MAX_PIECE; i++)
		{
			if (Puzzle.Piece[i].Group==k)
			{		
				Puzzle.Piece[i].x+=x;
				Puzzle.Piece[i].y+=y;
			}
		}
		for (j=0; j<Puzzle.PUZ.MAX_PIECE; j++)
		{
			if (Puzzle.Piece[j].Group==k)
			{
				if (Puzzle.Piece[j].x<LL)
					kx=Puzzle.Piece[j].x-LL;
				if (Puzzle.Piece[j].x>LR)
					kx=Puzzle.Piece[j].x-LR;
				if (Puzzle.Piece[j].y<LU)
					ky=Puzzle.Piece[j].y-LU;
				if (Puzzle.Piece[j].y>LD)
					ky=Puzzle.Piece[j].y-LD;
			}
		}
		for (j=0; j<Puzzle.PUZ.MAX_PIECE; j++)
		{
			if (Puzzle.Piece[j].Group==k)
			{
				Puzzle.Piece[j].x-=kx;
				Puzzle.Piece[j].y-=ky;
			}
		}
	}
	ox=lx;
	oy=ly-W_Y;

}

void DGame::Draw_All()
{
	Title_Window(Screen,NULL,0,0,SCREEN_W,SCREEN_H,GAME_TITLE);

	Menu.Draw(Screen);	

	Puzzle.Draw(mbit);
	blit(mbit,Screen.Bitmap,0,0,2,2*BOTTOM_OF_TITLE+4,SCREEN_W-5,SCREEN_H-(2*BOTTOM_OF_TITLE)-7);
	Make_Border(Screen,2,2*BOTTOM_OF_TITLE+4,SCREEN_W-3,SCREEN_H-3,DOWN);
	Draw_Screen();
}

void DGame::Delete_All()
{
	Menu.Delete();

	destroy_bitmap(mbit);
	Puzzle.Delete();

	uninstall_dlib();
}


int DGame::Which_Button()
{
	return 0;
}

void show_puz(int p)
{
	char fname[5][40]={"puzzle01.bmp","puzzle02.bmp","puzzle03.bmp",
				  "puzzle04.bmp","puzzle05.bmp"};
	BITMAP *tmp;
	tmp=load_bmp(fname[p],NULL);
	stretch_blit(tmp,Screen.Bitmap,0,0,tmp->w,tmp->h,280,160,200,140);		
	destroy_bitmap(tmp);
}

int DGame::Pick()
{
	int dn=0,puz=0;
	DRadioGroup rad;
	DButton but[4];

	Screen.Clear();

	but[0].Create(240,360,60,20,"Ok");
	but[1].Create(340,360,80,20,"Cancel");
	but[2].Create(320,320,60,20,"Up");
	but[3].Create(400,320,60,20,"Down");

	rad.Create(150,180,0,40,0,1,"Small","Normal","Large","@@@");


	do
	{		
		Title_Window(Screen,NULL,120,90,520,390,"Pick a Puzzle");
		rad.Draw(Screen);
		but[0].Draw(Screen);
		but[1].Draw(Screen);	
		but[2].Draw(Screen);
		but[3].Draw(Screen);
		Screen.Text("Size Pieces",150,140);
		Screen.Text("Puzzle",280,140);
		show_puz(puz);
		draw_sprite(Screen.Bitmap,(BITMAP*)data[PIECE1+rad.Which_Select()].dat,160,300);
		Draw_Screen();

		if (Mouse.Click())
		{
			if (but[0].Pressed())
			{
				dn=1;
			}
			if (but[1].Pressed())
			{
				dn=2;
			}
			if (but[2].Pressed())
			{
				puz--;
				if (puz<0) 
					puz=4;
				show_puz(puz);
			}
			if (but[3].Pressed())
			{
				puz++;
				if (puz>4) 
					puz=0;
				show_puz(puz);
			}
		}
		if (Mouse.Held())
		{
			rad.Check_Button();
		}

	} while (!dn);

	but[0].Delete();
	but[1].Delete();
	but[2].Delete();
	but[3].Delete();

	if (dn==1)
	{
		Puzzle.New_Puzzle(S_SMALL+rad.Which_Select(),puz);
		return 0;
	}
	
	return 1;
}

bool DGame::Game_Over()
{
	int i;
	for (i=0; i<Puzzle.PUZ.MAX_PIECE; i++)
	{
		if (Puzzle.Piece[i].Group!=1) return false;
	}

	return true;
}


void DGame::Program()
{
	int dn=0,mouse_state=UP,p,l,ms=M_NORMAL;
	

	Init_All();
	W_Y=2*BOTTOM_OF_TITLE+4;

	Screen.Clear();
	masked_blit((BITMAP*)data[SPLASH].dat,Screen.Bitmap,0,0,120,100,400,200);

	do
	{
		Draw_Screen();
		if (Mouse.Click()) dn=1;
		if (key[KEY_ENTER]) dn=1;
	} while (!dn);
	dn=0;

	dn=Pick();

	Screen.Clear();
	
	Draw_All();

	while (!dn)
	{
		if (key[KEY_ESC]) dn=1;
		if (key[KEY_1]) save_screen(640,480);

		if (mouse_y>W_Y)
		{
			if (ms!=M_HAND)
			{
				ms=M_HAND;
				Mouse.Change(ms);
			}
		}
		else
		{
			if (ms!=M_NORMAL)
			{
				ms=M_NORMAL;
				Mouse.Change(ms);
			}
		}


		if (mouse_b & 1)
		{
			p=Menu.Which_Pressed();		
			if (p==100 && mouse_state==UP)
			{
				Grab_Piece();
			}
			if (SPiece.n!=999)
			{
				Move();
			}
			if (p==0) 
			{
				Draw_All();
				l=Popup(Screen,Menu.Button[p],Pop);
				if (l==0)
				{
					if (Message(Screen,"Are You Sure","Yes","No",
									"Start a New Game?","@@@")==0)
					{
						dn=Pick();
					}
				}
				if (l==2)
				{
					if (Message(Screen,"Are You Sure","Yes","No",
									"Do you want to Quit?","@@@")==0)
					{
						dn=1;
					}
				}
			}
			mouse_state=DOWN;
		}

		if (key[KEY_T]) Pick();

		if (!(mouse_b & 1))
		{	
			if (mouse_state==DOWN)
			{
				p=Menu.Which_Pressed();
				if (p==100)
				{
					Let_Go();
				}
				if (p==1)
				{
					if (pr==false)
					{
						pr=true;
					}
					else
					{
						pr=false;
					}
				}
				if (p==2)
				{
					about(2000);
				}				
				if (p==3)
				{
					if (Message(Screen,"Are You Sure","Yes","No",
									"Do you want to Quit?","@@@")==0)
					{
						dn=1;
					}
				}
			}
			mouse_state=UP;
		}
		if (SPiece.n==999)
		{
			grp=0;
		}
		else
		{
			grp=Puzzle.Piece[SPiece.n].Group;
		}

  
	Draw_All();

		if (dn==0 && Game_Over()) 
		{
			rectfill(Screen.Bitmap,2,2*BOTTOM_OF_TITLE+4,SCREEN_W-3,SCREEN_H-3,0);
			blit(Puzzle.puzzle_bitmap,Screen.Bitmap,0,0,10,80,Puzzle.puzzle_bitmap->w,Puzzle.puzzle_bitmap->h);
			play_sound(SOUND1);
			if (Message(Screen,"Game Over","Yes","No",
				"You did it!",
				"Puzzle Complete",
				"",
				"Want to Try Again?",
				"@@@")==0) 
			{
				if (Pick()==1) dn=1;
			}
			else
			{
				dn=1;
			}
		}
	} 

	Delete_All();
}
