/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef PACKET_ENUM_H
#define PACKET_ENUM_H

enum {
	ID_PING, //0
	//client->server: login and password
	//server->client: character info sent after successful login
 	ID_LOGIN, //1
 	ID_MESSAGE, //2
 	ID_CHAT, //3
 	//client->server: information about PC's movement
 	//server->client: information about other players and monsters' position
 	ID_MOVE, //4
 	//server->client: information about another player in the area
 	ID_PLAYER, //5
 	//server->client: map change request
 	ID_MAP, //6
 	//server->client: a player has left the map (or game)
 	ID_QUIT, //7
 	ID_UDP_ACCEPTED, //8
 	//a clean exit from the other side of the connection
 	ID_DISCONNECTING, //9
 	//client->server: PvP mode request
 	//server->client: information about PvP state
 	ID_PVP, //10
 	//client->server: attack request
 	//server->client: attack information
 	ID_ATTACK, //11
	//server->client: soft delay info (in msecs)
	ID_DELAY, //12
	ID_DEATH, //13
	//server->client: information about current HP and MP
	ID_HPMP, //14
	//same as above, but includes also max HP and MP
	ID_MAXHPMP, //15
	ID_RUNE, //16
	ID_MONSTER, //17
	ID_LEVELUP, //18
	//server->client: information about changed look of a player (colors, headgear etc)
	ID_LOOK, //19
	//client->server: information about +1 to a stat, followed by stat index
	ID_STATUP, //20
	//client->server: sit/stand request
	//server->client: information about a player sitting or standing up
    ID_SIT, //21
    //client->server: regen request
    //server->client: information about regeneration
    ID_REGEN, //22
    //server->client: energy amount update
    ID_ENERGY, //23
    //server->client: information about time of the day (day/night system)
    ID_TIME, //24
    //server->client: inventory information
    ID_INVENTORY, //25
    ID_ITEMDELAY, //26
    //client->server: item use request
    //server->client: usable item addition
    ID_ITEMUSE, //27
    //server->client: etc item addition
    ID_ITEMETC, //28
    //client->server: loot open request
    //server->client: loot item addition
    ID_ITEMLOOT, //29
    ID_ITEMDEL, //30
    //server->client: some player used an item
    ID_USEDITEM, //31
    ID_HOTKEY_DELAY, //32
    //client->server: hotkey use request
    //server->client: hotkey state information
    ID_HOTKEY, //33
    ID_HOTKEY_LIST, //34
    //server->client: loot indicator from one object to another
    ID_LOOTDROP //35

};

#endif
