/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef SKILL_H_INCLUDE
#define SKILL_H_INCLUDE

#define HOTKEY_NONE 0
#define HOTKEY_ITEM 1
#define HOTKEY_SKILL 2

#define SKILLFLASH_RAYS 30

#include "object.h"

struct Hotkey
{
 Hotkey() : type(0) { }
 char type;
 unsigned short id,id2;
 int delay,orig_delay;
};

class SkillFlash : public Object
{
 public:
 SkillFlash(int col, Object *targ);
 void think();
 void draw_top();
 protected:
 float radius[SKILLFLASH_RAYS],angle[SKILLFLASH_RAYS],speed[SKILLFLASH_RAYS],rspeed[SKILLFLASH_RAYS];
 int color,life;
 Object *target;

};

extern Hotkey hotkeys[16];
extern int hotkey_colors[16];

void hotkey_reset();


#endif

