/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "main.h"
#include "skill.h"
#include "player.h"
#include "palette.h"
#include "lookup.h"
#include <math.h>

Hotkey hotkeys[16];

int hotkey_colors[16] = { 144, 146, 148, 150,   152, 154, 156, 158,
                          176, 178, 180, 182,   184, 186, 188, 190 };

SkillFlash::SkillFlash(int col, Object *targ)
: color(col), life(60), target(targ)
{
 for(int i = 0; i < SKILLFLASH_RAYS; i++)
 {
  angle[i] = (rand()%100)/100.0 * 6.28;
  speed[i] = (rand()%100)/100.0 * 0.4 - 0.2;
  radius[i] = 0;
  rspeed[i] = (rand()%100)/100.0 * 0.2 + 0.1;
 }
}

void SkillFlash::think()
{
 for(int i = 0; i < SKILLFLASH_RAYS; i++)
 {
  angle[i] += speed[i];
  speed[i] *= 0.97;
  radius[i] += rspeed[i];
  rspeed[i] *= 0.985;
 }
 life--;
 if(life == 1 || kill_counter != -1) remove = true;
}

void SkillFlash::draw_top()
{
 float x,y,x2,y2;
 int ix,iy;
 for(int i = 0; i < (life>SKILLFLASH_RAYS?SKILLFLASH_RAYS:life); i++)
 {
  x2 = x = cos(angle[i]) * radius[i];
  y2 = y = sin(angle[i]) * radius[i];
  x2 += target->x - cam_x + 8;
  y2 += target->y - cam_y;
  for(int j = 0; j < 8; j++)
  {
   color_map = trans_map + j;
   if(x2 < 1 || x2 >= buf->w -1 || y2 < 1 || y2 >= buf->h - 1) continue;
   ix = (int)x2; iy = (int)y2;
   buf->line[iy][ix] = color_map->data[buf->line[iy][ix]][color];
   if(life > 40)
   buf->line[iy+1][ix] = color_map->data[buf->line[iy+1][ix]][color];
   if(life > 30)
   buf->line[iy-1][ix] = color_map->data[buf->line[iy-1][ix]][color];
   if(life > 20)
   buf->line[iy][ix+1] = color_map->data[buf->line[iy][ix+1]][color];
   if(life > 10)
   buf->line[iy][ix-1] = color_map->data[buf->line[iy][ix-1]][color];
   x2 += x; y2 += y;
  }
 }
}

void hotkey_reset()
{
 for(int i = 0; i < 16; i++)
  hotkeys[i].type = 0;
}
