/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "rune.h"
#include "palette.h"
#include "network.h"
#include "particle.h"
#include "player.h"
#include <math.h>
#include <stdio.h>
#define RUNE_NUM 1

DATAFILE *rune = 0;
BITMAP *symbols[64][RUNE_NUM];

Rune::Rune(int _x, int _y, int _type)
: type(_type)
{
 y = _y*16;
 x = _x*16 - 8;
 sort_y = 0;
 rot_phase = rot_phase2 = 0;
 ps = new ParticleSystem(500,140,8,1);
 ps->polar_mode = true;
 ps->set_point_emitter(x+16,y+8,0.01,0.3,0.03,0.5,20,120,200);
 ps->polar_radius = 45.0;
 ps->polar_scaling = 0.2;
 ps->sort_y = y;
 ps->active = false;
}

void Rune::think()
{
 if(kill_counter != -1) remove = true;
 rot_phase++;
 rot_phase2--;
 if(rot_phase > 127) rot_phase = 0;
 if(rot_phase2 < 0) rot_phase2 = 191;

 if((player->x + 8) / 16 == (x+8)/16 && (player->y + 8) / 16 == y/16)
  ps->active = true;
 else
  ps->active = false;
}

void Rune::draw_lower()
{
 draw_sprite(buf,symbols[rot_phase/2][type],x - cam_x, y - cam_y);
 draw_sprite(buf,symbols[rot_phase2/3][type],x - cam_x, y - cam_y);
}

void rune_init()
{
 rune = load_datafile("gfx/rune.dat");
 if(!rune) allegro_message("gfx/rune.dat not found.\n");
 BITMAP *tmp = create_bitmap(32,32);
 for(int t = 0; t < RUNE_NUM; t++)
  for(int i=0; i<64; i++)
  {
   clear_bitmap(tmp);
   rotate_sprite(tmp,(BITMAP*)rune[t].dat,0,0,itofix(i*4));
   symbols[i][t] = create_bitmap(32,16);
   for(int j=0; j<16; j++)
    blit(tmp,symbols[i][t],0,j*2,0,j,32,1);
  }
 unload_datafile(rune);
}

void rune_cleanup()
{
 for(int t = 0; t < RUNE_NUM; t++)
  for(int i=0; i<64; i++)
   destroy_bitmap(symbols[i][t]);
}
