/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "main.h"
#include "play.h"
#include "login.h"
#include "console.h"
#include "map.h"
#include "network.h"
#include "object.h"
#include "player.h"
#include "rune.h"
#include "palette.h"
#include "damage.h"
#include "gui.h"
#include "monster.h"
#include "item.h"
#include "particle.h"
#include "skill.h"
#include "help.h"
#include <time.h>

bool hp_display_on = true;
bool skill_display_on = true;
bool menu_active = false;
bool aura_updated = false;
bool combat_mode = false;
//use upper or lower skill hotkey row? (default: upper)
bool skill_alt = false;
bool hold_b = false;
unsigned char current_time = 128;

int last_pvp_request = 0;

void play_init()
{
 set_palette(black_palette);
 clear(conf_triplebuffer?page[!current_page]:screen);
 console_init();
 map_init();
 damage_init();
 gui_init();
 rune_init();
 monster_init();
 help_init();
 pvp_mode = false;
 map_loaded = false;
 menu_active = false;
 combat_mode =false;
// active_palette = base_palette;
// fade_in(active_palette,8);
 gui_hp_display();
 timer = 0;
 item_delay = 0;
}

void play_run_logic()
{
 if(help_active && keypressed())
 {
  help_active = false;
 } else
 if(!console_active && keypressed())
 {
  static int k;
  k = readkey();
  if((k>>8) == KEY_F1) help_active = true;
  if(menu_active)
  {
   if((k>>8) == keymap[KEYMAP_B] && !combat_mode)
   {
    gui_hide(DIALOG_MENU_MENU,DIR_RIGHT,true,5,1);
    gui_hide(DIALOG_MENU_STAT,DIR_LEFT,true,5,1);
    gui_hide(DIALOG_MENU_ITEM_UP,DIR_UP,true,1,4);
    gui_hide(DIALOG_MENU_ITEM_DOWN,DIR_DOWN,true,1,4);
    gui_hide(DIALOG_HOTKEY,DIR_DOWN,true,1,4);
    gui_hide(DIALOG_LOOT,DIR_DOWN,true,1,4);
    if(hp_display_on) gui_unhide(DIALOG_HP_DISPLAY);
    if(skill_display_on) gui_unhide(DIALOG_SKILL_DISPLAY);
    menu_active = false;
   }
   if(!console_active)
    gui_handle_keypress(k>>8);
  } else
  {
   if((k>>8) == keymap[KEYMAP_B] && !combat_mode && !key[keymap[KEYMAP_L]])
   {
    gui_menu();
    if(hp_display_on) gui_hide(DIALOG_HP_DISPLAY,DIR_UP,false,1,2);
    if(skill_display_on) gui_hide(DIALOG_SKILL_DISPLAY,DIR_UP,false,1,2);
    menu_active = true;
   }
   if((k>>8) == KEY_F5 && time(0) - last_pvp_request > 5)
   {
    static unsigned char pvp = ID_PVP;
    network_send_packet(&pvp,1);
    last_pvp_request = time(0);
    return;
   } else
   if((k>>8) == KEY_F6)
   {
    if(hp_display_on)
     gui_hide(DIALOG_HP_DISPLAY,DIR_UP,false,1,2);
    else
     gui_unhide(DIALOG_HP_DISPLAY);
   hp_display_on = !hp_display_on;
   } else
   if((k>>8) == KEY_F7)
   {
    if(skill_display_on)
     gui_hide(DIALOG_SKILL_DISPLAY,DIR_UP,false,1,2);
    else
     gui_unhide(DIALOG_SKILL_DISPLAY);
   skill_display_on = !skill_display_on;
   } else
   if((((k>>8) == keymap[KEYMAP_L] && key[keymap[KEYMAP_R]]) || ((k>>8) == keymap[KEYMAP_R] && key[keymap[KEYMAP_L]])) && !combat_mode)
   {
    unsigned char request = ID_SIT;
    network_send_packet(&request,1);
   } else
   if((k>>8) == keymap[KEYMAP_Y])
   {
    if(key[keymap[KEYMAP_L]])
    {
     unsigned char request = ID_REGEN;
     network_send_packet(&request,1);
    }
   } else
   if((k>>8) == KEY_ESC)
   {
    play_cleanup();
    game_state = GAME_LOGIN;
    network_notify_disconnect();
    login_init();
   }
   if((k>>8) == KEY_SPACE)
    combat_mode = !combat_mode;
   if((k>>8) == KEY_F1)
   {
    //new SkillFlash(169);
//    new LootIndicator(rand()%100,rand()%100,player);
   }
   if((k>>8) == keymap[KEYMAP_B] && !key[keymap[KEYMAP_L]])
   {
    hold_b = true;
   }
   if(!menu_active && combat_mode && hold_b && !player->hard_delay)
   {
    unsigned char pack[2];
    pack[0] = ID_HOTKEY;
    pack[1] = 255;
    if((k>>8) ==  keymap[KEYMAP_A])  pack[1] = 0; else
    if((k>>8) ==  keymap[KEYMAP_X])  pack[1] = 2; else
    if((k>>8) ==  keymap[KEYMAP_Y])  pack[1] = 3;
    if(pack[1] != 255)
    {
     if(key[keymap[KEYMAP_UP]] || key[keymap[KEYMAP_DOWN]] ||
        key[keymap[KEYMAP_LEFT]] || key[keymap[KEYMAP_RIGHT]])
      pack[1] += 4;
     if(skill_alt) pack[1] += 8;
     network_send_packet(pack,2);
     hold_b = false;
    }
   }
  } //!menu_active
   simulate_keypress(k);
 }
 //aura modification
 #define AURA_CHANGE 2
 if(key[keymap[KEYMAP_L]])
 {
  if(key[keymap[KEYMAP_A]])
  {
   if(aura_target[1] >= AURA_CHANGE && aura_target[0]+AURA_CHANGE <= 100) { aura_target[1] -= AURA_CHANGE; aura_target[0] += AURA_CHANGE; }
   if(aura_target[2] >= AURA_CHANGE && aura_target[0]+AURA_CHANGE <= 100) { aura_target[2] -= AURA_CHANGE; aura_target[0] += AURA_CHANGE; }
   aura_updated = true;
  } else
  if(key[keymap[KEYMAP_X]])
  {
   if(aura_target[0] >= AURA_CHANGE && aura_target[1]+AURA_CHANGE <= 100) { aura_target[0] -= AURA_CHANGE; aura_target[1] += AURA_CHANGE; }
   if(aura_target[2] >= AURA_CHANGE && aura_target[1]+AURA_CHANGE <= 100) { aura_target[2] -= AURA_CHANGE; aura_target[1] += AURA_CHANGE; }
   aura_updated = true;
  } else
  if(key[keymap[KEYMAP_B]])
  {
   if(aura_target[0] >= AURA_CHANGE && aura_target[2]+AURA_CHANGE <= 100) { aura_target[0] -= AURA_CHANGE; aura_target[2] += AURA_CHANGE; }
   if(aura_target[1] >= AURA_CHANGE && aura_target[2]+AURA_CHANGE <= 100) { aura_target[1] -= AURA_CHANGE; aura_target[2] += AURA_CHANGE; }
   aura_updated = true;
  }
 }
 if(aura_current[0] < aura_target[0]) { aura_current[0]++; } else if(aura_current[0] > aura_target[0]) { aura_current[0]--; }
 if(aura_current[1] < aura_target[1]) { aura_current[1]++; } else if(aura_current[1] > aura_target[1]) { aura_current[1]--; }
 if(aura_current[2] < aura_target[2]) { aura_current[2]++; } else if(aura_current[2] > aura_target[2]) { aura_current[2]--; }
 if(item_delay) item_delay--;

 if(hold_b && !key[keymap[KEYMAP_B]])
 {
  if(!menu_active && combat_mode)
  {
   unsigned char pack[2] = { ID_HOTKEY, 1 };
   if(key[keymap[KEYMAP_UP]] || key[keymap[KEYMAP_DOWN]] ||
      key[keymap[KEYMAP_LEFT]] || key[keymap[KEYMAP_RIGHT]])
    pack[1] += 4;
   if(skill_alt) pack[1] += 8;
   network_send_packet(pack,2);
  }
  hold_b = false;
 }
 for(int i = 0; i < 16; i++)
  if(hotkeys[i].type != HOTKEY_NONE && hotkeys[i].delay > 1)
   hotkeys[i].delay--;

 camera_think();
 console_think();
 map_think();
 object_list_think();
 gui_think();
 help_think();
}

void play_draw_all()
{
 palette_draw();
 clear(buf);
 map_draw_lower();
 object_list_draw_lower();
 map_draw_mid();
 object_list_draw_upper();
 map_draw_upper();
 object_list_draw_top();
 console_draw();
 gui_draw();
 help_draw();
 if(item_delay) draw_sprite(buf,(BITMAP*)maindata[DATA_NOITEM].dat,308,0);
 if(key[KEY_F2])
  textprintf_right_ex(buf,font,buf->w,0,255,-1,"Ping %d",current_ping);
}

void play_cleanup()
{
 fade_out_range(8,0,223);
 console_cleanup();
 map_cleanup();
 damage_cleanup();
 object_list_cleanup();
 monster_cleanup();
 gui_cleanup();
 rune_cleanup();
 for(int i=0; i<CLASS_MAX; i++)
  if(player_sprites[i])
  {
   unload_datafile(player_sprites[i]);
   player_sprites[i] = 0;
  }
 for(int i=0; i<HEAD_MAX; i++)
  if(head_sprites[i])
  {
   unload_datafile(head_sprites[i]);
   head_sprites[i] = 0;
  }
}
