/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef PARTICLE_H_INCLUDE
#define PARTICLE_H_INCLUDE
#define MAX_TRAIL 10
#include "object.h"

struct Particle
{
 float x,y,vx,vy;
 int color;
 int life;
};

class ParticleSystem : public Object
{
 public:
 ParticleSystem(int _max_particles, int _color, int _trail, int _trail_skip = 1);
 virtual ~ParticleSystem();
 void setx(int _x) { emx = _x; }
 void sety(int _y) { sort_y = emy = _y; }
 int getx() { return emx; }
 int gety() { return emy; }

 void think();
 void draw_lower();
 void draw_upper();
 void set_point_emitter(int _x, int _y, float _vx, float _vy, float _randvx, float _randvy, int particles_per_sec, int min_life, int max_life);
 void set_box_emitter(int _x, int _y, int _w, int _h, float _vx, float _vy, float _randvx, float _randvy, int particles_per_sec, int min_life, int max_life);
 bool polar_mode;
 float polar_radius,polar_scaling;
 bool active;
 protected:
 void _add_particle(float _x, float _y, float _vx, float _vy, int color, int _life);
 int max_particles;
 int emitter_type, life, life_rand, w, h;
 int emx,emy;
 float pps, p_frame_count;
 float vx,vy,randvx,randvy;
 int last_particle,start_color;
 int trail_last_particle[MAX_TRAIL];
 int trail_trans[MAX_TRAIL];
 int trail, trail_skip;
 Particle *particles;
 Particle *trail_particles;
};
#endif
