/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef PALETTE_H_INCLUDE
#define PALETTE_H_INCLUDE
#include <allegro.h>

void palette_fade_in(RGB color, int l = 32, bool fill = true);
void palette_fade_out(RGB color, int l = 24);
void palette_set_backup();
void palette_restore();
void palette_set_fade(RGB color, float intensity);
void palette_set_multiply(RGB color, float intensity);
void palette_update_time();
void palette_draw();

void camera_think();

extern PALETTE base_palette, current_palette;
extern int cam_x, cam_y, cam_target_x, cam_target_y;
//a function that will be called when fadeout ends, reset after each use
extern void (*event_func)();
#endif
