/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef OBJECT_H_INCLUDE
#define OBJECT_H_INCLUDE

#include "main.h"
#include <stdio.h>
#include <list>
using namespace std;
struct Packet;
class Animator;

class Object
{
 public:
 Object();
 virtual ~Object();
 void run_animators();
 virtual void setx(int _x) { x = _x; }
 virtual void sety(int _y) { sort_y = y = _y; }
 virtual int getx() { return x; }
 virtual int gety() { return y; }
 virtual void think() = 0;
 virtual void draw_upper() {};
 virtual void draw_lower() {};
 virtual void draw_top() {}
 virtual void display_name() {};
 virtual void attack(int target, Packet *attack_data) {}
 //calculates number of hits etc, then executes combat_hit() a number of times
 void _attack(int target, Packet *attack_data);
 //replace with any custom attack effects when inheriting
 virtual void combat_hit(int target, Packet *attack_data, int num) {}

 virtual void get_dmg(unsigned int dmg, int delay, float _vx, float _vy) {}
 virtual void evade(int effect_duration) {}

 virtual void reload_sprites(unsigned char *data) {}
 virtual void effect_colorize(int color, int l) {}
 virtual BITMAP* get_head() { return 0; }
 virtual BITMAP* get_current_sprite() { return 0; }
 float speed;
 int kill_counter;
 //only some objects respect this, set to -1 for unlimited
 int lifetime;
 //after what time does the object actually appear in game? (in frames)
 int show_delay;
 int direction;
 //sort_y is the value used for sorting. should be dependant on Y coordinate
 //high_offset is a modificator to sort_y for upper layer
 int x,y,high_offset,sort_y;
 //time in frames the evasion effect should be shown
 int evade_counter;
 int net_x, net_y;
 bool net_updated;
 int obj_num;
 bool visible;
 bool remove;
 bool targetable;
 bool dead;
 bool sitting;
 //is the object from a newly loaded map?
 bool newmap;
 //stunlock, decreased each frame
 int stunlock;
 list<Animator*> animators;
};

class Animator
{
 public:
 Animator() : remove(false) {}
 virtual ~Animator() {}
 virtual void animate(Object *) {}
 bool remove;
};

class RemoveAnimator : public Animator
{
 public:
 RemoveAnimator(int t) : life(t) { }
 void animate(Object *);
 int life;
};

class AttachAnimator : public Animator
{
 public:
 AttachAnimator(Object *t, bool rem_v = false) : target(t), remove_when_visible(rem_v) { x = t->getx(); y = t->gety(); }
 void animate(Object *);
 int x,y;
 Object *target;
 bool remove_when_visible;
};

void object_list_think();
void object_list_draw_top();
void object_list_draw_upper();
void object_list_draw_lower();
void object_list_cleanup();

extern list<Object*> object_list;
#endif
