/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef NETWORK_H_INCLUDE
#define NETWORK_H_INCLUDE

#include <nl.h>
#include "../../packet_enum.h"

#define MAX_PACKET_SIZE 5000
int time_diff(NLtime *a, NLtime *b);

struct Packet
{
 unsigned char _data[MAX_PACKET_SIZE];
 unsigned char *data;
 int length, orig_length;
};


void network_init();
void network_update();
void network_cleanup();
void network_login(char *ip, char *login, char *password);
void network_disconnect();
void network_notify_disconnect();

void network_send_message(char *msg, int length);
void network_send_position(int x, int y);
void network_send_packet(unsigned char *packet, int length);

void handle_tcp_packet(Packet *p);
void handle_udp_packet(Packet *p);

//lag to server, in miliseconds
extern int current_ping;
extern bool network_disabled, udp_try_connection;
extern int current_ping;
extern NLtime last_ping_nltime;
extern long int verification_code;

#endif
