/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef MONSTER_H_INCLUDE
#define MONSTER_H_INCLUDE
#include "object.h"
#include <stdio.h>

class ParticleSystem;

class ParticleMonster : public Object
{
 public:
 ParticleMonster(int _x, int _y, int _color);
 void think();
 void draw_upper();
 void draw_lower() {}
 void attack(int target, Packet *attack_data);
 void combat_hit(int target, Packet *attack_data, int num);
 void get_dmg(unsigned int dmg, int delay, float _vx, float _vy);
 void _turn_to_target(Object *o);

 void setx(int _x) { fx = x = _x; }
 void sety(int _y) { fy = sort_y = y = _y; }

 int color;
 float h, h_step;
 float fx,fy;
 ParticleSystem *ps;
};

void monster_init();
void monster_cleanup();

#endif
