/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef MAP_H_INCLUDE
#define MAP_H_INCLUDE

#define LAYER_LOWER 0
#define LAYER_MID 1
#define LAYER_UPPER 2

#define MAPFLAGC_INDOOR 1
struct Object;
void map_init();
void map_think();
void map_draw_lower();
void map_draw_mid();
void map_draw_upper();
void map_cleanup();

void map_change(int charnum, unsigned int num);
void map_change();
void map_save(unsigned int num);
bool map_check(int x, int y);

void map_putpixel(int x, int y, int tile, int layer);
int map_getpixel(int x, int y, int layer);

extern Object *objects[256];
extern BITMAP *tileset;
extern int map_w, map_h;
extern unsigned int map_num;
extern char tileset_path[50];

extern unsigned int next_charnum,next_map,next_x,next_y,next_map_flags;
extern char map_flags;
extern bool map_loaded;

#endif
