/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "lookup.h"
#include "palette.h"
#include "map.h"
#include <stdio.h>

COLOR_MAP trans_map[TRANS_LEVELS_TOTAL];

void lookup_gen()
{
 char path[100];
 sprintf(path,"gfx/tilesets/%s.cmp",tileset_path);
 PACKFILE *f = pack_fopen(path,F_READ_PACKED);
 if(!f) allegro_message("Color mapping table not found.\n");
 pack_fread(trans_map,256*256*4,f);
 for(int i = 0; i < 4; i++)
  for(int x = 0; x < 256; x++)
   for(int y = 0; y < 256; y++)
    trans_map[7-i].data[x][y] = trans_map[i].data[y][x];
 for(int i = 0; i < 9; i++)
  for(int x = 0; x < 256; x++)
  {
    trans_map[i].data[0][x] = x;
//    trans_map[i].data[x][0] = x;
  }

 //multiply map
 pack_fread(trans_map+TRANS_LEVELS,256*256,f);
 pack_fclose(f);
}
