/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "login.h"
#include "network.h"
#include "main.h"
#include "edit.h"
#include <math.h>
#include <string.h>
#include <stdio.h>
#define pi 3.1415926L

PALETTE pal;
unsigned char ptab1[64000];
unsigned char ptab2[64000];
int box_w, box_h;
float circle1=0,circle2=0,circle3=0,circle4=0,circle5=0,circle6=0,circle7=0,circle8=0;
long int px1,py1,px2,py2,px3,py3,px4,py4,proll=0;
BITMAP *plasma_mask = 0;
BITMAP *credits = 0;
int credits_scroll = 0;


char ip[50] = "127.0.0.1";
char login[17] = "";
char password[17] = "";
char message[256] = "ENTER:Connect F10:Map editor";
FONT *default_font;

DIALOG login_dialog[] =
{
 { d_rtext_proc, 0,100,90,12, 255,1, 0,0, 0,0, (char*)"Server IP:",NULL,NULL },
 { d_rtext_proc, 0,112,90,12, 255,1, 0,0, 0,0, (char*)"Login:",NULL,NULL },
 { d_rtext_proc, 0,124,90,12, 255,1, 0,0, 0,0, (char*)"Password:",NULL,NULL },
 { d_edit_proc,  100,100,100,12, 255,1, 0,0, 49,strlen(ip)-1,ip,NULL,NULL },
 { d_edit_proc,  100,112,100,12, 255,1, 0,0, 16,0,login,NULL,NULL },
 { d_edit_proc,  100,124,100,12, 255,1, 0,0, 16,0,password,NULL,NULL },
 { NULL,         0,0,0,0,       0,0, 0,0, 0,0, NULL,NULL,NULL }
};
DIALOG_PLAYER *login_dialog_player = 0;


void calc_plasma_tab()
{
 box_w = buf->w / 2;
 box_h = buf->h / 2;
 float temp;
 for(long int i=0; i<buf->h; i++)
  for(long int j=0; j<buf->w; j++)
  {
   ptab1[(i*buf->w)+j]=(unsigned char) (( sqrt(16.0+(box_h-i)*(box_h-i)+(box_w-j)*(box_w-j))-4) *5 );
   temp=sqrt(16.0+(box_h-i)*(box_h-i)+(box_w-j)*(box_w-j))-4;
   ptab2[(i*box_w*2)+j]=(unsigned char)((sin(temp/9.5)+1)*90);
  }
}

void plasma_draw(long x1,long y1,long x2,long y2,long x3,long y3,long x4,long y4,long roll)
{
 static int color;
 for(int i=0; i<plasma_mask->h; i++)
  for(int j=0; j<plasma_mask->w; j++)
   if(plasma_mask->line[i][j])
   {
    color = ptab1[320*(i+y1)+j+x1]+roll+
            ptab2[320*(i+y2)+j+x2]+
            ptab2[320*(i+y3)+j+x3]+
            ptab2[320*(i+y4)+j+x4] & 254;
    buf->line[i<<1][j<<1] = buf->line[(i<<1)+1][j<<1] = buf->line[i<<1][(j<<1)+1] = buf->line[(i<<1)+1][(j<<1)+1] = color;
   }
}

void login_init()
{
 set_palette(black_palette);
 calc_plasma_tab();
 double r=1.0/6.0*pi,g=3.0/6.0*pi, b=5.0/6.0*pi,u;
 for(int i=0; i<256; i++)
 {
  u=2*pi/256*i;
  #define plasmacol(u,a) ((cos((u)+(a))+1)*31)
  pal[i].r = (unsigned char)plasmacol(u,r); pal[i].g = (unsigned char)plasmacol(u,g); pal[i].b = (unsigned char)plasmacol(u,b);
 }
 pal[1].r = 0; pal[1].g = 0; pal[1].b = 0;
 pal[255].r = 63; pal[255].g = 63; pal[255].b = 63;

 plasma_mask = (BITMAP*)maindata[DATA_LOGO].dat;

 FILE *f = fopen("data/credits.txt","r");
 if(!f) allegro_message("Couldn't find data/credits.txt");
 int linecount = 0;
 while(!feof(f))
  if(fgetc(f) == '\n')
   linecount++;
 fseek(f,0,SEEK_SET);

 credits = create_bitmap(100,font_height*linecount+100);
 clear_to_color(credits,1);
 char line[256],c;
 int pos;
 for(int i = 0; i < linecount; i++)
 {
  pos = 0;
  #ifdef WIN32
  while((c = fgetc(f)) != '\n')
  {
   line[pos++] = c;
  }
  #else
  while((c = fgetc(f)) != '\r')
  {
   line[pos++] = c;
  }
  fgetc(f);
  #endif
  line[pos] = 0;
  textout_ex(credits,font,line,0,i*font_height,255,1);
 }
 fclose(f);
 blit(credits,credits,0,0,0,font_height*linecount,100,100);


 gui_fg_color = 255;
 gui_bg_color = 1;
 static bool read_config = true;
 if(read_config)
 {
  strncpy(ip,get_config_string("network","default_host","127.0.0.1"),50);
  strncpy(login,get_config_string("network","login",""),17);
  read_config = false;
 }
 if(login[0] == 0)
  login_dialog_player = init_dialog(login_dialog,4);
 else
  login_dialog_player = init_dialog(login_dialog,5);
 clear_to_color(conf_triplebuffer?page[0]:screen,1);
 clear_to_color(conf_triplebuffer?page[1]:screen,1);
 login_draw_all();
 main_update_screen();
 fade_in(pal,8);
 timer = 0;
}

void login_run_logic()
{
 proll += 1;
 circle1+=0.020/6;
 circle2-=0.025/6;
 circle3+=.1/6;
 circle4-=.05/6;
 circle5+=.1/6;
 circle6-=.03/6;
 circle7+=.15/6;
 circle8-=.02/6;
 px2=(long)((box_w/2)+(box_w/2)*sin(circle1));
 py2=(long)((box_h/2)+(box_h/2)*cos(circle2));
 px1=(long)((box_w/2)+(box_w/2)*cos(circle3));
 py1=(long)((box_h/2)+(box_h/2)*sin(circle4));
 px3=(long)((box_w/2)+(box_w/2)*cos(circle5));
 py3=(long)((box_h/2)+(box_h/2)*sin(circle6));
 px4=(long)((box_w/2)+(box_w/2)*cos(circle7));
 py4=(long)((box_h/2)+(box_h/2)*sin(circle8));
 credits_scroll++;
 if(credits_scroll > credits->h*2-200)
  credits_scroll = 0;
}

void login_draw_all()
{
 clear_to_color(buf,1);
 plasma_draw(px1,py1,px2,py2,px3,py3,px4,py4,proll);
 gui_set_screen(buf);
 if(keypressed())
 {
  static int k;
  k = readkey();
  if((k>>8) == KEY_ENTER) network_login(ip,login,password); else
  if((k>>8) == KEY_ESC) shutdown_flag = true; else
  if((k>>8) == KEY_F10)
  {
   login_cleanup();
   game_state = GAME_EDIT;
   edit_init();
   return;
  } else
  simulate_keypress(k);
 }
 update_dialog(login_dialog_player);
 broadcast_dialog_message(MSG_DRAW,0);
 static int l;
 l = strlen(password);
 for(int i=0; i<l; i++)
  textout_ex(buf,font,"*",100+i*font_width,124,255,1);
 textout_ex(buf,font,message,0,190,255,1);
 blit(credits,buf,0,credits_scroll/2,220,100,100,100);
}

void login_cleanup()
{
 if(credits)
  destroy_bitmap(credits);
 if(login_dialog_player)
  shutdown_dialog(login_dialog_player);
 fade_out(8);
 timer = 0;
}

void login_setmessage(char *msg, int l)
{
 strncpy(message,msg,l);
 message[l] = 0;
}
