/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef ITEM_H_INCLUDE
#define ITEM_H_INCLUDE
#include <stdio.h>
#include <list>
#define MAX_GLYPHS 5
#define DESC_LINE_LENGTH 55
#define MAX_ITEMS 500
#define MAX_MONSTERS 500
#define SCRIPT_MAX_LENGTH 2000

#define INV_USE 0
#define INV_EQUIP 1
#define INV_ETC 2
#define INV_LOOT 3

#include "object.h"

using namespace std;
struct DATAFILE;
struct Packet;

struct Item
{
 Item(unsigned short _id, unsigned short _quantity)
 : id(_id), quantity(_quantity) {}
 Item(const Item &other)
 : id(other.id), quantity(other.quantity) {}
 unsigned short id;
 unsigned short quantity;
};

struct _WeaponData
{
 char spirit_name[17];
 unsigned char spirit_level;
};

struct _Glyph
{
 unsigned char type;
 unsigned char level;
};

struct EquipItem
{
 //armor/sword/shield etc.
 unsigned char type;
 unsigned char material;
 unsigned char grade;
 //three upgradable parametres (white, red, black), role depends on equip type
 unsigned char pw,pr,pb;
 unsigned short limit;
 //applies only if type == some weapon class
 _WeaponData *wd;
 _Glyph glyphs[MAX_GLYPHS];
};

struct _DescriptionLine
{
 _DescriptionLine(char *t)
 { strcpy(d,t); }
 _DescriptionLine(const _DescriptionLine &other)
 { strcpy(d,other.d); }
 char d[DESC_LINE_LENGTH];
};

struct ItemDatabaseEntry
{
 ItemDatabaseEntry()
 : script(0) {}
 ~ItemDatabaseEntry()
 { if(script) delete[] script; }
 unsigned short id;
 int type;
 char name[32];
 list<_DescriptionLine> description;
 char *script;
 int datanum;
};

struct MonsterDatabaseEntry
{
 unsigned short id;
 char name[30];
};

//left blank for now
struct EquipDatabaseEntry
{
};

#define LOOTINDICATOR_TAIL 10

class LootIndicator : public Object
{
 public:
 LootIndicator(int sx, int sy, Object *targ);
 void draw_top();
 void think();
 protected:
 Object *target;
 int prev_x[LOOTINDICATOR_TAIL], prev_y[LOOTINDICATOR_TAIL];
 float v, fx, fy;
 float vx, vy;
};


extern list<Item> inventory_use,inventory_etc,inventory_loot;
extern list<EquipItem> inventory_equip;
extern int selected_item,selected_inv;
extern ItemDatabaseEntry item_use_db[MAX_ITEMS];
extern ItemDatabaseEntry item_etc_db[MAX_ITEMS];
extern MonsterDatabaseEntry monster_db[MAX_MONSTERS];
extern DATAFILE *itemuse, *itemetc;

extern int item_delay;

void item_init();
void item_cleanup();

void item_add(int inv, unsigned short id, unsigned short quantity);
void item_remove(int inv, unsigned short id, unsigned short quantity);
void item_use(unsigned short id);
void item_read_inventory(Packet *packet);

void item_render_use(Object *user, unsigned short id);

void item_display(int inv, unsigned short id, unsigned short quantity, int x, int y, int w, int color = 253);

#endif
