/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "main.h"
#include "help.h"
#include "play.h"
#include "lookup.h"
#include "gui.h"
#include <stdio.h>

HelpPage help[HELP_PAGES];
int help_width = 0;
bool help_active;

void help_init()
{
 FILE *f = fopen("data/help.txt","rb");
 for(int i = 0; i < HELP_PAGES; i++)
 {
  char *ptr = help[i].text;
  for(int j = 0; j < 16; j++)
  {
   fgets(ptr,66,f);
   ptr += 64;
  }
  if(feof(f)) return;
  help[i].active = true;
 }
 fclose(f);
 help_active = false;
}

void help_draw()
{
 if(!help_width) return;
 drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
 color_map = trans_map+3;
 rectfill(buf,160-help_width,0,160+help_width,200,254);
 solid_mode();
// if(!help_active) return;
 int current_page = 0;
 if(!menu_active)
  current_page = combat_mode?1:0;
 else
  current_page = gui_get_help_page();
 if(!help[current_page].active) return;
 char *ptr = help[current_page].text;
 char tbuf[2];
 tbuf[1] = 0;
 tbuf[0] = *ptr;
 bool next_special = false;

 for(int i = 0; i < 16; i++)
  for(int j = 0; j < 64; j++,tbuf[0] = *(++ptr))
  {
   if(*ptr == '#') { next_special = true; continue; }
   if(ABS(32-j) <= help_width/5)
   {
    if(next_special)
    {
     next_special = false;
     switch(*ptr)
     {
      case 'A' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,0,0,j * 5 - 6, i*12,12,12); break;
      case 'B' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,12,0,j * 5 - 6, i*12,12,12); break;
      case 'X' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,24,0,j * 5 - 6, i*12,12,12); break;
      case 'Y' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,36,0,j * 5 - 6, i*12,12,12); break;
      case 'a' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,48,0,j * 5 - 6, i*12,12,12); break;
      case 'b' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,60,0,j * 5 - 6, i*12,12,12); break;
      case 'x' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,72,0,j * 5 - 6, i*12,12,12); break;
      case 'y' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,84,0,j * 5 - 6, i*12,12,12); break;
      case 'L' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,96,0,j * 5 - 6, i*12,12,12); break;
      case 'R' : masked_blit((BITMAP*)maindata[DATA_BUTTONS].dat,buf,108,0,j * 5 - 6, i*12,12,12); break;
      default: break;
     }
    }
    else
    textout_ex(buf,font,tbuf,j*5,i*12,255,-1);
   }
  }


}

void help_think()
{
 if(help_active && help_width < 160) help_width += 8;
 if(!help_active && help_width > 0) help_width -= 8;
}
