/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef GHOST_H_INCLUDE
#define GHOST_H_INCLUDE
#include "object.h"

class Ghost : public Object
{
 public:
 Ghost(Object *o, float _vx, float _vy, int _trans_start, int _trans_duration, bool _position_follow, bool _frame_follow);
 ~Ghost();
 void think();
 void draw_upper();
 void draw_lower();
 void setx(int _x) { fx = x = _x; }
 void sety(int _y) { fy = sort_y = y = _y; }

 Object *obj;
 float fx,fy,vx,vy;
 int trans_start,trans_duration,direction;
 int trans_counter;
 bool position_follow,frame_follow;
 BITMAP *sprite;
};

#endif
