/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "ghost.h"
#include "palette.h"
#include "player.h"
#include "lookup.h"

Ghost::Ghost(Object *o, float _vx, float _vy, int _trans_start, int _trans_duration, bool _position_follow, bool _frame_follow)
: obj(o), vx(_vx), vy(_vy), trans_start(_trans_start), trans_duration(_trans_duration), position_follow(_position_follow), frame_follow(_frame_follow)
{
 sprite = create_bitmap(obj->get_current_sprite()->w,obj->get_current_sprite()->h);
 clear_bitmap(sprite);
 if(obj->direction == DIR_LEFT)
  draw_sprite_h_flip(sprite,obj->get_current_sprite(),0,0);
 else
  draw_sprite(sprite,obj->get_current_sprite(),0,0);
 x = obj->x;
 sort_y = y = obj->y;
 fx = fy = 0.0;
 direction = obj->direction;
 trans_counter = 0;
}

Ghost::~Ghost()
{
 destroy_bitmap(sprite);
}

void Ghost::think()
{
 trans_counter++;
 if(trans_counter > trans_duration)
 {
  trans_start--;
  trans_counter = 0;
 }
 if(trans_start < 0 || kill_counter != -1) { remove = true; return; }
 if(frame_follow)
 {
  clear_bitmap(sprite);
  if(obj->direction == DIR_LEFT)
   draw_sprite_h_flip(sprite,obj->get_current_sprite(),0,0);
  else
   draw_sprite(sprite,obj->get_current_sprite(),0,0);
  direction = obj->direction;
 }
 if(position_follow)
 {
  x = obj->x;
  sort_y = y = obj->y;
 }
 fx += vx;
 fy += vy;
}

void Ghost::draw_upper()
{
 if(kill_counter != -1) return;
 color_map = trans_map + trans_start;
 set_clip_rect(buf,0,y+(int)fy-cam_y-16,buf->w-1,y+(int)fy-cam_y);
 draw_trans_sprite(buf,sprite,x+(int)fx-cam_x-8,y+(int)fy-cam_y-16);
 set_clip_rect(buf,0,0,buf->w-1,buf->h-1);
}
void Ghost::draw_lower()
{
 if(kill_counter != -1) return;
 color_map = trans_map + trans_start;
 set_clip_rect(buf,0,y+(int)fy-cam_y,buf->w-1,y+(int)fy-cam_y+16);
 draw_trans_sprite(buf,sprite,x+(int)fx-cam_x-8,y+(int)fy-cam_y-16);
 set_clip_rect(buf,0,0,buf->w-1,buf->h-1);
}
