/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "main.h"
#include "login.h"
#include "edit.h"
#include "map.h"
#include "palette.h"
#include "object.h"
#include "player.h"
#include "gui.h"
#include <stdio.h>

#define BUTTON_OK 2

bool mid_layer_visible = true, upper_layer_visible = true;
int tileset_scroll = 0;
int selected_tile = 0;
char edit_message[80] = "";
int edit_message_timeout = 0;
char map_num_char[20] = "0";
char button_ok[10] = "OK";
char button_cancel[10] = "Cancel";
char text_open[20] = "Open map no.:";
char map_size_char[20] = "0 0";
char text_resize[20] = "Resize to (W H):";
char text_tileset[20] = "Tileset name:";

int _mouse_y, _mouse_x;
DIALOG open_dialog[] =
{
 //proc     x y w h   fg bg    key flags   d1 d2     dp1 dp2 dp3
 { d_text_proc,   120,80,80,12,  255,0, 0,0,      0,0,   text_open,0,0 },
 { d_edit_proc,   120,100,80,12, 255,0, 0,0,      10,0,  map_num_char,0,0 },
 { d_button_proc, 120,120,40,12, 255,0, 0,D_EXIT, 10, 0, button_ok,0,0 },
 { d_button_proc, 160,120,40,12, 255,0, 0,D_EXIT, 10, 0, button_cancel,0,0 },
 { NULL, 0,0,0,0, 0,0, 0,0,  0,0, NULL,NULL,NULL }
};

DIALOG resize_dialog[] =
{
 //proc     x y w h   fg bg    key flags   d1 d2     dp1 dp2 dp3
 { d_text_proc,   120,80,80,12,  255,0, 0,0,      0,0,   text_resize,0,0 },
 { d_edit_proc,   120,100,80,12, 255,0, 0,0,      10,0,  map_size_char,0,0 },
 { d_button_proc, 120,120,40,12, 255,0, 0,D_EXIT, 10, 0, button_ok,0,0 },
 { d_button_proc, 160,120,40,12, 255,0, 0,D_EXIT, 10, 0, button_cancel,0,0 },
 { NULL, 0,0,0,0, 0,0, 0,0,  0,0, NULL,NULL,NULL }
};

DIALOG tileset_dialog[] =
{
 //proc     x y w h   fg bg    key flags   d1 d2     dp1 dp2 dp3
 { d_text_proc,   120,80,80,12,  255,0, 0,0,      0,0,   text_tileset,0,0 },
 { d_edit_proc,   120,100,80,12, 255,0, 0,0,      50,0,  tileset_path,0,0 },
 { d_button_proc, 120,120,40,12, 255,0, 0,D_EXIT, 10, 0, button_ok,0,0 },
 { d_button_proc, 160,120,40,12, 255,0, 0,D_EXIT, 10, 0, button_cancel,0,0 },
 { NULL, 0,0,0,0, 0,0, 0,0,  0,0, NULL,NULL,NULL }
};

void edit_init()
{
 map_init();

 create_player(0,0);
 map_change(0,0);
 if(install_mouse() == -1) allegro_message("ERROR: couldn't find initialize mouse driver.\n");
 //set_mouse_sprite(NULL);
 scare_mouse();
 position_mouse(buf->w/2,buf->h/2);
 gui_init();
// show_mouse(buf);
// scare_mouse();
// show_os_cursor(MOUSE_CURSOR_ARROW);
 tileset_scroll = 0;
 selected_tile = 0;
 edit_message[0] = 0;
 edit_message_timeout = 0;
}

int flash_counter = 0;
bool flash_reverse = true;


void edit_run_logic()
{
 camera_think();
 map_think();
 object_list_think();
 gui_think();
 _mouse_x = mouse_x;
 _mouse_y = mouse_y;
 if(edit_message_timeout) edit_message_timeout--;
 if(flash_reverse)
 {
  flash_counter-=2;
  if(flash_counter < 2)
   flash_reverse = false;
 } else
 {
  flash_counter+=2;
  if(flash_counter > 61)
  flash_reverse = true;
 }


 if(keypressed())
 {
  static int k;
  k = readkey();
  if((k>>8) == KEY_ESC)
  {
   edit_cleanup();
   game_state = GAME_LOGIN;
   login_init();
  }
  if((k>>8) == KEY_F1)
  {
   gui_set_screen(screen);
   gui_bg_color = 0;
   alert("Alt+R: Randomize Alt+J: Jump","Ctrl+O:Open Ctrl+S:Save Ctrl+R:Resize Ctrl+T:Change tileset","F3:Toggle layer display",
         "OK",NULL,0,0);
  }
  if((k>>8) == KEY_F3)
  {
   if(upper_layer_visible) { mid_layer_visible = false; upper_layer_visible = false; } else
   if(mid_layer_visible) { upper_layer_visible = true; } else
   mid_layer_visible = true;
  }
  //Ctrl+S: save
  if((k>>8) == KEY_S && key_shifts&KB_CTRL_FLAG) map_save(map_num);
  //Ctrl+O: open
  if((k>>8) == KEY_O && key_shifts&KB_CTRL_FLAG)
  {
   gui_set_screen(screen);
   if(do_dialog(open_dialog,1) == BUTTON_OK)
   { map_num = atoi(map_num_char); map_change(0,map_num); }
   timer = 0;
  }
  //Ctrl+R: resize
  if((k>>8) == KEY_R && key_shifts&KB_CTRL_FLAG)
  {
   gui_set_screen(screen);
   sprintf(map_size_char,"%d %d",map_w,map_h);
   if(do_dialog(resize_dialog,1) == BUTTON_OK)
   {
    sscanf(map_size_char,"%d %d",&map_w,&map_h);
    if(map_w < 0) map_w = 0; if(map_h < 0) map_h = 0;
    if(map_w > 255) map_w = 255; if(map_h > 255) map_h = 255;
   }
   timer = 0;
  }
  //Alt+R: randomize
  if((k>>8) == KEY_R && key_shifts&KB_ALT_FLAG)
  {
   int active_layer = mid_layer_visible ? (upper_layer_visible ? LAYER_UPPER : LAYER_MID) : LAYER_LOWER;
   for(int i = 0; i < map_h; i++)
    for(int j = 0; j < map_w; j++)
     if(!(rand()%50))
      map_putpixel(j,i,selected_tile,active_layer);
    }
  //Alt+J: jump
  if((k>>8) == KEY_J && key_shifts&KB_ALT_FLAG)
  {
   player->setx(_mouse_x+cam_x);
   player->sety(_mouse_y+cam_y);
  }
  //Ctrl+T: tileset change
  if((k>>8) == KEY_T && key_shifts&KB_CTRL_FLAG)
  {
   gui_set_screen(screen);
   if(do_dialog(tileset_dialog,1) == BUTTON_OK)
   {
    map_save(map_num);
    map_change(0,map_num);
   }
   timer = 0;
  }
 }
 if(mouse_needs_poll())
  poll_mouse();
 if(key[KEY_TAB])
 {
  if(_mouse_y > buf->h - 32 && tileset_scroll + buf->h < 256) tileset_scroll++;
  if(_mouse_y < 32 && tileset_scroll > 0) tileset_scroll --;
  if(mouse_b & 1) selected_tile = ((_mouse_x/16)  & 15) + ((_mouse_y + tileset_scroll) & 240);
 } else
 if(mouse_b & 1) map_putpixel((cam_x + _mouse_x)/16, (cam_y + _mouse_y)/16, selected_tile, mid_layer_visible ? (upper_layer_visible ? LAYER_UPPER : LAYER_MID) : LAYER_LOWER);
 if(mouse_b & 2) selected_tile = map_getpixel((cam_x + _mouse_x)/16, (cam_y + _mouse_y)/16, mid_layer_visible ? (upper_layer_visible ? LAYER_UPPER : LAYER_MID) : LAYER_LOWER);
 clear_keybuf();
}

void edit_draw_all()
{
 palette_draw();
 current_palette[254].r = flash_counter;
 current_palette[254].g = flash_counter;
 current_palette[254].b = flash_counter;
 set_color(254,current_palette+254);
 clear(buf);
 map_draw_lower();
 object_list_draw_lower();
 if(mid_layer_visible) map_draw_mid();
 object_list_draw_upper();
 if(upper_layer_visible) map_draw_upper();
 object_list_draw_top();
 if(key[KEY_TAB])
 {
  if(mid_layer_visible || upper_layer_visible)
   blit(tileset,buf,0,256+tileset_scroll,0,0,256,256);
  else
   blit(tileset,buf,0,tileset_scroll,0,0,256,256);
  rect(buf,(selected_tile&15) * 16, (selected_tile & 240) - tileset_scroll, (selected_tile&15) * 16 + 16, (selected_tile & 240) + 16 - tileset_scroll, 254);
  vline(buf,256,0,256,255);
  hline(buf,0,256,256,255);
 }
 if(edit_message_timeout)
  textout_centre_ex(buf,font,edit_message,buf->w/2,buf->h-32,255,-1);
 gui_draw();
 textprintf_right_ex(buf,font,buf->w,0,255,-1,"%d layers",1+mid_layer_visible+upper_layer_visible);
 textprintf_right_ex(buf,font,buf->w,10,255,-1,"%d %d",(player->x+8)/16,(player->y+8)/16);
 hline(buf,_mouse_x-2,_mouse_y,_mouse_x-6,254);
 hline(buf,_mouse_x+2,_mouse_y,_mouse_x+6,254);
 vline(buf,_mouse_x,_mouse_y-2,_mouse_y-6,254);
 vline(buf,_mouse_x,_mouse_y+2,_mouse_y+6,254);
}

void edit_cleanup()
{
 fade_out_range(8,0,223);
 map_cleanup();
 gui_cleanup();
 object_list_cleanup();
 for(int i=0; i<CLASS_MAX; i++)
  if(player_sprites[i])
  {
   unload_datafile(player_sprites[i]);
   player_sprites[i] = 0;
  }
 for(int i=0; i<HEAD_MAX; i++)
  if(head_sprites[i])
  {
   unload_datafile(head_sprites[i]);
   head_sprites[i] = 0;
  }
 remove_mouse();
}
