/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef DAMAGE_H_INCLUDE
#define DAMAGE_H_INCLUDE
#include "object.h"
#define DAMAGE_MAX_LENGTH 6

//damage display class
class Damage : public Object
{
 public:
 Damage(unsigned int v, int c, int startx, int starty, float _vx, float _vy);
 void think();
 void draw_top();
 void setx(int _x) { fx = x = _x; }
 void sety(int _y) { fy = sort_y = y = _y; }
 protected:
 bool reverse_scale;
 float scale;
 float fx, fy;
 unsigned int value;
 float vx,vy;
 int color;
 int len;
 char str[DAMAGE_MAX_LENGTH];
};

//end-delay effect
class DelayEnd : public Object
{
 public:
 DelayEnd(int m = 50);
 void think();
 void draw_top();
 protected:
 int radius;
 int max;
};

class RegenWave : public Object
{
 public:
 RegenWave();
 void think();
 void draw_upper() {}
 void draw_lower();
 void sety(int _y) {  y = _y; }
 protected:
 int radius;
};

class ChatSymbol : public Object
{
 public:
 ChatSymbol(int _char_num);
 void think();
 void draw_top();
 protected:
 int phase,h,char_num;
};

class FlashText : public Object
{
 public:
 FlashText(char *t, Object *targ);
 void think();
 void draw_top();
 protected:
 int phase;
 int l;
 Object *target;
 char text[50];
 int color;
};

void damage_init();
void damage_cleanup();

#endif
