/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "main.h"
#include "console.h"
#include "login.h"
#include "network.h"
#include "player.h"
#include <string.h>
#define MAX_CHARACTERS 99
#define MAX_DISPLAY_CHARACTERS 150
#define MAX_LINES 8
#define SCROLL_DELAY 600
#define SCROLL_SPEED 1

bool console_active = false;
char text[MAX_CHARACTERS+1];
int console_length, console_size;
int scroll_max, scroll_pos, scroll_timer_count, line_count;

char lines[MAX_LINES][MAX_DISPLAY_CHARACTERS];
BITMAP *line_images[MAX_LINES];
int colors[MAX_LINES];

void console_init()
{
 console_active = false;
 console_length = 0;
 console_size = 0;
 scroll_max = 0;
 scroll_pos = 0;
 scroll_timer_count = 0;
 line_count = 0;
 for(int i=0; i<MAX_LINES; i++)
  line_images[i] = 0;
// waiting_line_count = 0;
}

void console_think()
{
 if(scroll_timer_count > 0) scroll_timer_count -= line_count;
 else
 {
  if(line_count)
  {
   scroll_pos += SCROLL_SPEED*line_count;
   if(scroll_pos > scroll_max)
   {
    line_count--;
    destroy_bitmap(line_images[line_count]);
    scroll_pos = 0;
    if(line_count)
     scroll_max = strlen(lines[line_count-1])*font_width + (line_images[line_count-1]?16:0);
    if(line_count < MAX_LINES-1)
     scroll_timer_count = SCROLL_DELAY;
   }
  }
 }

 static int scancode, char_value;
 if(keypressed())
 {
  char_value = ureadkey(&scancode);
  clear_keybuf();
  if(console_active)
  {
   if(scancode == KEY_ENTER)
   {
    if(!console_length) { console_active = false; return; }
    network_send_message(text,console_size);
    if(text[0] == '#')
    {
     char msg2[1000];
     text[console_length] = 0;
     sprintf(msg2,"%s: %s",login,text+1);
     console_add_line(msg2);
    } else
    console_add_line(player->get_head(),text,console_size,player->obj_num);
    console_length = 0;
    console_size = 0;
    console_active = false;
    return;
   }
   if(scancode == KEY_BACKSPACE)
   {
    if(!console_length) return;
    console_size--;
    console_length--;
    return;
   }
   if(((scancode >= KEY_A && scancode <= KEY_9_PAD) ||
       (scancode >= KEY_TILDE && scancode <= KEY_SPACE) ||
       (scancode >= KEY_SLASH_PAD && scancode <= KEY_PLUS_PAD) ||
       (scancode >= KEY_EQUALS_PAD && scancode <= KEY_SEMICOLON) )
      && console_size+1 < MAX_CHARACTERS)
   {
    text[console_size] = (char)char_value;
    console_size++;
    console_length++;
   }
  }
  else
   if(scancode == KEY_ENTER) { console_active = true; }
 }
}

void console_draw()
{
 for(int i=0; i<line_count-1; i++)
  if(line_images[i])
  {
   masked_blit(line_images[i],buf,0,0,0,buf->h-font_height*(i+2) + font_height/2 - 8,16,16);
   textout_ex(buf,font,lines[i],17,buf->h-font_height*(i+2)+1,colors[i],-1);
   textout_ex(buf,font,lines[i],16,buf->h-font_height*(i+2),255,-1);
  } else
  {
   textout_ex(buf,font,lines[i],1,buf->h-font_height*(i+2)+1,colors[i],-1);
   textout_ex(buf,font,lines[i],0,buf->h-font_height*(i+2),255,-1);
  }
 if(line_count > 0)
 {
  if(line_images[line_count-1])
  {
   masked_blit(line_images[line_count-1],buf,0,0,-scroll_pos,buf->h-font_height*(line_count+1) + font_height/2 - 8,16,16);
   textout_ex(buf,font,lines[line_count-1],-scroll_pos+17,buf->h-font_height*(line_count+1)+1,colors[line_count-1],-1);
   textout_ex(buf,font,lines[line_count-1],-scroll_pos+16,buf->h-font_height*(line_count+1),255,-1);
  } else
  {
   textout_ex(buf,font,lines[line_count-1],-scroll_pos+1,buf->h-font_height*(line_count+1)+1,colors[line_count-1],-1);
   textout_ex(buf,font,lines[line_count-1],-scroll_pos,buf->h-font_height*(line_count+1),255,-1);
  }
 }
 if(!console_active) return;
 char c[MAX_CHARACTERS+1];
 strncpy(c,text,console_size);
 c[console_size] = 0;
 textout_ex(buf,font,c,0,buf->h-font_height,255,-1);
 textout_ex(buf,font," ",console_length*font_width,buf->h-font_height,0,255);
}

void console_cleanup()
{
 for(int i=0; i<line_count; i++)
  if(line_images[i]) destroy_bitmap(line_images[i]);
}

void console_add_line(char *l, int length, int color)
{
 if(length >= MAX_DISPLAY_CHARACTERS) length = 0;
 if(line_count >= MAX_LINES)
 {
  for(int i = MAX_LINES - 2; i >= 0; i--)
  {
   strcpy(lines[i+1],lines[i]);
   line_images[i+1] = line_images[i];
   colors[i+1] = colors[i];
  }
  if(line_images[MAX_LINES-1])
   destroy_bitmap(line_images[MAX_LINES-1]);
  line_images[0] = 0;
  strncpy(lines[0],l,length);
  lines[0][length] = 0;
  colors[0] = color;
  return;
 } //if
 for(int i = line_count - 1; i >= 0; i--)
 {
  strcpy(lines[i+1],lines[i]);
  line_images[i+1] = line_images[i];
  colors[i+1] = colors[i];
 }
 line_images[0] = 0;
 strncpy(lines[0],l,length);
 lines[0][length] = 0;
 colors[0] = color;
 if(!line_count)
 {
  scroll_max = length*font_width+16;
  scroll_pos = 0;
  scroll_timer_count = SCROLL_DELAY;
 }
 line_count++;
}


void console_add_line(BITMAP *picture, char *l, int length, int color)
{
 if(length >= MAX_DISPLAY_CHARACTERS) length = 0;
 if(line_count >= MAX_LINES)
 {
  for(int i = MAX_LINES - 2; i >= 0; i--)
  {
   strcpy(lines[i+1],lines[i]);
   line_images[i+1] = line_images[i];
   colors[i+1] = colors[i];
  }
  if(line_images[MAX_LINES-1])
   destroy_bitmap(line_images[MAX_LINES-1]);
  line_images[0] = create_bitmap(16,16);
  blit(picture,line_images[0],0,0,0,0,16,16);
  strncpy(lines[0],l,length);
  lines[0][length] = 0;
  colors[0] = color;
//  if(scroll_max < length*font_width+16) scroll_max = length * font_width + 16;
  return;
 } //if
 for(int i = line_count - 1; i >= 0; i--)
 {
  strcpy(lines[i+1],lines[i]);
  line_images[i+1] = line_images[i];
  colors[i+1] = colors[i];
 }
 line_images[0] = create_bitmap(16,16);
 blit(picture,line_images[0],0,0,0,0,16,16);
 strncpy(lines[0],l,length);
 lines[0][length] = 0;
 colors[0] = color;
 if(!line_count)
 {
  scroll_max = length*font_width+16;
  scroll_pos = 0;
  scroll_timer_count = SCROLL_DELAY;
 }
 line_count++;
}

void console_add_line(char *l)
{
 console_add_line(l,strlen(l));
}
