/*   Copyright 2005,2006 Pawe Niegowski
*
*    This file is part of Fenrir.
*
*    Fenrir is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    Fenrir is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with Fenrir; if not, write to the Free Software
*    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "combat.h"
#include "main.h"
#include "palette.h"
#include "lookup.h"
#include "particle.h"
#include <math.h>

#define PHASE 20
#define HALF_PHASE 10
#define SLASH_SCALE 10.0

Slash::Slash(Object *t, float rot, int c, int sc, int off_y)
: target(t), rotation(rot), color(c), scale(sc), offset_y(off_y)
{
 x = target->x + 8;
 y = sort_y =  target->y + offset_y;
 //front
 coords[0] = SLASH_SCALE/2; coords[1] = 0.0;
 //up
 coords[2] = 0.0; coords[3] = 0.0;
 //back
 coords[4] = SLASH_SCALE/2; coords[5] = 0.0;
 //down
 coords[6] = 0.0; coords[7] = 0.0;
 phase = 0;
}

void Slash::think()
{
 if(show_delay)
 {
  show_delay--;
  return;
 }
 phase++;
 int h = HALF_PHASE - ABS(phase-HALF_PHASE);
 coords[3] = h * 0.5 / HALF_PHASE;
 coords[7] = -h * 0.5 / HALF_PHASE;
 coords[0] = phase* -SLASH_SCALE/PHASE + SLASH_SCALE/2;
 coords[2] = coords[0] - coords[0] * 0.2;
 coords[6] = coords[0] - coords[0] * 0.2;
 if(phase > PHASE+1 || kill_counter > -1) remove = true;
}

void Slash::draw_upper()
{
 if(show_delay || phase < 2) return;
 float coords_turned[8];
 float angle, length;
 for(int i = 0; i < 4; i++)
 {
  //angle
  angle = atan2(coords[i*2+1],coords[i*2]) + rotation;
  //length
  length = sqrt(coords[i*2]*coords[i*2] + coords[i*2+1]*coords[i*2+1]);
  coords_turned[i*2] = cos(angle)*length;
  coords_turned[i*2+1] = sin(angle)*length;
 }

 int coords_i[8];
 for(int i = 0; i < 4; i++)
 {
  coords_i[i*2] = (int)(coords_turned[i*2] * scale) + x - cam_x;
  coords_i[i*2+1] = (int)(coords_turned[i*2+1] * scale) + y - cam_y;
 }
 color_map = trans_map+3;
 drawing_mode(DRAW_MODE_TRANS,0,0,0);
 polygon(buf,4,coords_i,color);
 solid_mode();

}
