#include <allegro.h>
#include <stdio.h>

#define SPRITE_W 32
#define SPRITE_H 32
#define HEAD_W 16
#define HEAD_H 16

int main(int argc, char *argv[])
{
 allegro_init();
 if(argc < 3) { printf("Usage: headgen sprite_file output_file\n"); return 0; }
 BITMAP *sprite = load_bitmap(argv[1],NULL);
 if(!sprite) { printf("Couldn't open sprite file, aborting.\n"); return 0; }
 FILE *f = fopen(argv[2],"w");
 if(!f) { destroy_bitmap(sprite); printf("Couldn't open output file, aborting.\n"); return 0; }
 for(int n=0; n < sprite->h/SPRITE_H; n++)
 {
   for(int y=0; y<SPRITE_H; y++)
    for(int x=0; x<SPRITE_W; x++)
     if(sprite->line[y+n*SPRITE_H][x] == 255) 
       fprintf(f,"%d %d\n",x-HEAD_W/2,y-HEAD_H/2);
 }
 printf("Head coords generated successfully.\n");
 fclose(f);
 destroy_bitmap(sprite);
 return 0;
 
}
END_OF_MAIN();
