#include <allegro.h>
#include <string.h>

#include "gfx.h"
#include "pal.h"
#include "menu.h"
#include "game.h"
#include "sound.h"

MENY menu;

int menu_use(void)
{
	
	int keyp, ret = -1;
	
	while(ret == -1)
	{
		gfx_menu_loop();
		keyp = readkey();
		if ((keyp >> 8) == KEY_DOWN)
		{
			menu.active_item++;
			play_menu3();
		}

		if ((keyp >> 8) == KEY_UP)
		{
			menu.active_item--;
			play_menu3();
		}

		if (((keyp >> 8) == KEY_ESC) & (menu.standard >= 0))
		{
			ret = menu.standard;
			play_menu(800);
		}
		if ((keyp >> 8) == KEY_ENTER)
		{
			if (menu.disabled[menu.active_item])
				play_menu2();
			else
			{
				ret = menu.active_item;
				play_menu(1000);
			}
		}
		if (menu.active_item >= menu.items)
			menu.active_item = menu.items - 1;
		if (menu.active_item < 0)
			menu.active_item = 0;
	}
	return ret;
	
}

void menu_main(void)
{
	menu.items = 4;
	

	menu.disabled[0] = FALSE;
	strcpy (menu.item[0], "New Game");
	if (game_on)
	{
		menu.standard = 1;
		menu.active_item = 1;
		menu.disabled[1] = FALSE;
	}
	else
	{
		menu.standard = -1;
		menu.active_item = 0;
		menu.disabled[1] = TRUE;
	}
	strcpy (menu.item[1], "Resume Game");
	menu.disabled[2] = FALSE;
	strcpy (menu.item[2], "Change Resolution");
	menu.disabled[3] = FALSE;
	strcpy (menu.item[3], "Quit");
}

void menu_option(void)
{
	menu.items = 7;
	menu.active_item = 0;
	menu.standard = 6;
	menu.disabled[0] = FALSE;
	strcpy (menu.item[0], "320x200");
	menu.disabled[1] = FALSE;
	strcpy (menu.item[1], "640x480");
	menu.disabled[2] = FALSE;
	strcpy (menu.item[2], "800x600");
	menu.disabled[3] = FALSE;
	strcpy (menu.item[3], "1024x768");
	menu.disabled[4] = FALSE;
	strcpy (menu.item[4], "1152x864");
	menu.disabled[5] = FALSE;
	strcpy (menu.item[5], "1280x1024");
	menu.disabled[6] = FALSE;
	strcpy (menu.item[6], "Back");
}

int menu_show(void)
{
	int ret;

	
	while (1)
	{	
		clear_keybuf();
		pal_menu();
		menu_main();

		ret = menu_use();
		if (ret == 0)
		{
			fade_out_menu();
			game_init();
			game_loop();
		}
		if (ret == 1)
		{
			game_loop();
			play_menu(800);
		}
		if (ret == 2)
		{
			menu_option();
			ret = menu_use();
			if (ret != 6)
			{
				if (ret == 0)
					use_gfx_mode (8, 320, 200);
				if (ret == 1)
					use_gfx_mode (8, 640, 480);
				if (ret == 2)
					use_gfx_mode (8, 800, 600);
				if (ret == 3)
					use_gfx_mode (8, 1024, 768);
				if (ret == 4)
					use_gfx_mode (8, 1152, 864);
				if (ret == 5)
					use_gfx_mode (8, 1280, 1024);
				if(gfx_reset())
				{
					use_gfx_mode (8, 320, 200);
					gfx_reset();
				}
			}
			ret = 2;
		}
		if (ret == 3)
		{
			fade_out_menu();
			return 0;
		}
		menu.active_item = 1;
	}
	
	
	
	return 0;
}

