#include <allegro.h>
#include <math.h>

#include "3d.h"
#include "game.h"
#include "map.h"
#include "pal.h"
#include "timer.h"
#include "data.h"
#include "menu.h"

#define	LIGHT_RADIUS	160

BITMAP *scrbuf;

int scrx = 640, scry = 480, bpp = 8;

float noneg(float i)
{
	if (i < 0)
		return 0;
	return i;
}

int pulsate(int i)
{
	if (i >= 32)
		return 63-i;
	return i;
}

void gfx_game_loop(void)
{
	int i, x, z, mx, my;
	float cubex, cubey, cubez;
	float map_shade[17][17];
	V3D_f map_3d[17][17];
	float cube_shade[6];
	MATRIX_f rm, qm, cm, tm;
	V3D_f nvertex[8];
	V3D_f nnormal[8];
	V3D_f nstar[NUM_STARS];
	
	get_mouse_mickeys (&mx, &my);
	
	if (!mouse_b) {
		camera.xrot -= ((float)my/10);
		camera.yrot += ((float)mx/10);
	}
	else
	{
		camera.distance -= ((float)my/2);
		//camera.fov += ((float)mx/25);		// For debugging
	}


	if (camera.xrot > 0)
		camera.xrot = 0;
	if (camera.xrot < -64)
		camera.xrot = -64;
	if (camera.distance < 40)
		camera.distance = 40;
	if (camera.distance > 700)
		camera.distance = 700;
	
	if (camera.yrot >= 256)
		camera.yrot -= 256;
	if (camera.yrot < 0)
		camera.yrot += 256;
	
	// Cube matrix stuff
	if (player.direction != DIRECTION_NONE) {
		get_translation_matrix_f(&tm, rot_offset[player.direction].x, rot_offset[player.direction].y, rot_offset[player.direction].z);
		if (player.direction==DIRECTION_LEFT)
			get_z_rotate_matrix_f(&qm, -player.angle);
		if (player.direction==DIRECTION_FRONT)
			get_x_rotate_matrix_f(&qm, player.angle);
		if (player.direction==DIRECTION_RIGHT)
			get_z_rotate_matrix_f(&qm, player.angle);
		if (player.direction==DIRECTION_BACK)
			get_x_rotate_matrix_f(&qm, -player.angle);

		matrix_mul_f (&tm, &qm, &rm);
		get_translation_matrix_f(&tm, -rot_offset[player.direction].x, -rot_offset[player.direction].y, -rot_offset[player.direction].z);
		matrix_mul_f (&rm, &tm, &rm);
	}
	else
	{
		rm = identity_matrix_f;
		qm = identity_matrix_f;
	}

	get_translation_matrix_f(&tm, player.x*20+10, 0, player.z*20+10);
	matrix_mul_f (&rm, &tm, &tm);
	
	apply_matrix_f(&tm, 0, 0, 0, &cubex, &cubey, &cubez);
	
	// Camera matrix stuff
	get_camera_matrix_f (&cm, 0, 0, -camera.distance, 0, 0, 1, 0, -1, 0, camera.fov, 1);
	get_rotation_matrix_f(&rm, camera.xrot, camera.yrot, 0);
	matrix_mul_f (&rm, &cm, &cm);

	//get_translation_matrix_f(&tm, -player.x*20-10, 0, -player.z*20-10);
	get_translation_matrix_f(&rm, -cubex, 0, -cubez);
	matrix_mul_f (&rm, &cm, &cm);


	// Project stars
	for (i = 0; i<NUM_STARS; i++)
	{
		apply_matrix_f(&cm, star[i].x, star[i].y, star[i].z, &nstar[i].x, &nstar[i].y, &nstar[i].z);
		persp_project_f(nstar[i].x, nstar[i].y, nstar[i].z, &nstar[i].x, &nstar[i].y);
	}
	
	clear (scrbuf);
	
	// Draw stars
	for (i = 0; i<NUM_STARS; i++)
	{
		if (nstar[i].z > 0)
		{
			if (RAD_STARS == 0)
				putpixel (scrbuf, nstar[i].x, nstar[i].y, star[i].c);
			else
				circlefill (scrbuf, nstar[i].x, nstar[i].y, RAD_STARS, star[i].c);
		}
	}
	
	/* TODO:  Draw background sprites here!	*/
	/*        Planets galaxies etc.		*/

	// Project map (floor)
	for (x = 0; x < 17; x++)
		for (z = 0; z < 17; z++)
		{
			apply_matrix_f(&cm, x * 20, 10, z * 20, &map_3d[x][z].x, &map_3d[x][z].y, &map_3d[x][z].z);
			persp_project_f(map_3d[x][z].x, map_3d[x][z].y, map_3d[x][z].z, &map_3d[x][z].x, &map_3d[x][z].y);
			map_shade[x][z] = noneg(LIGHT_RADIUS-sqrt(((float)x*20-cubex)*((float)x*20-cubex)+((float)z*20-cubez)*((float)z*20-cubez)))/LIGHT_RADIUS;
		}
	
	// Draw map
	for (x = 0; x < 16; x++)
		for (z = 0; z < 16; z++)
		{
			// If any vertex of the polygon is behind the camera, don't draw it!
			if ((map[x][z] != 0)&(map_3d[x][z].z > 0)&(map_3d[x+1][z].z > 0)&(map_3d[x][z+1].z > 0)&(map_3d[x+1][z+1].z > 0)) {
				if ((x != endx)|(z != endz))	// Shade the square...
				{
					map_3d[x][z].c = map_shade[x][z]*32+map[x][z]*32;
					map_3d[x+1][z].c = map_shade[x+1][z]*32+map[x][z]*32;
					map_3d[x][z+1].c = map_shade[x][z+1]*32+map[x][z]*32;
					map_3d[x+1][z+1].c = map_shade[x+1][z+1]*32+map[x][z]*32;
				}
				else				// ...or, if its the endpoint, create some nifty glow effect
				{
					map_3d[x][z].c = pulsate((timer/16) % 64) + map[x][z] * 32;
					map_3d[x+1][z].c = pulsate((timer/16 + 16) % 64) + map[x][z] * 32;
					map_3d[x][z+1].c = pulsate((timer/16 + 32) % 64) + map[x][z] * 32;
					map_3d[x+1][z+1].c = pulsate((timer/16 + 48) % 64) + map[x][z] * 32;
				}
				quad3d_f(scrbuf, POLYTYPE_GCOL, NULL, &map_3d[x][z], &map_3d[x][z+1], &map_3d[x+1][z+1], &map_3d[x+1][z]);
			}
		}

	// Project cube
	for (i = 0; i<8; i++)
	{
		apply_matrix_f(&tm, vertex[i].x, vertex[i].y, vertex[i].z, &nvertex[i].x, &nvertex[i].y, &nvertex[i].z);
		apply_matrix_f(&cm, nvertex[i].x, nvertex[i].y, nvertex[i].z, &nvertex[i].x, &nvertex[i].y, &nvertex[i].z);
		persp_project_f(nvertex[i].x, nvertex[i].y, nvertex[i].z, &nvertex[i].x, &nvertex[i].y);
	}
	
	// Rotate vertex normals, and calculate shade-levels
	for (i = 0; i<8; i++)
	{
		apply_matrix_f(&qm, normal[i].x, normal[i].y, normal[i].z, &nnormal[i].x, &nnormal[i].y, &nnormal[i].z);
		cube_shade[i] = noneg(dot_product_f(nnormal[i].x, nnormal[i].y, nnormal[i].z, light.x, light.y, light.z));
	}
	
	// Draw cube
	for (i = 0; i<6; i++) 
	{
		// If any vertex of the polygon is behind the camera, don't draw it! (should never happen, but whatever... =)
		if (polygon_z_normal_f(&nvertex[quad[i][0]], &nvertex[quad[i][1]], &nvertex[quad[i][2]]) > 0)
		{
			if ((nvertex[quad[i][0]].z > 0)&(nvertex[quad[i][1]].z > 0)&(nvertex[quad[i][2]].z > 0)&(nvertex[quad[i][3]].z > 0)) {
				nvertex[quad[i][0]].c = cube_shade[quad[i][0]]*32+player.color[i]*32;
				nvertex[quad[i][1]].c = cube_shade[quad[i][1]]*32+player.color[i]*32;
				nvertex[quad[i][2]].c = cube_shade[quad[i][2]]*32+player.color[i]*32;
				nvertex[quad[i][3]].c = cube_shade[quad[i][3]]*32+player.color[i]*32;
				quad3d_f(scrbuf, POLYTYPE_GCOL, NULL, &nvertex[quad[i][0]], &nvertex[quad[i][1]], &nvertex[quad[i][2]], &nvertex[quad[i][3]]);
			}
		}
	}
			
	if (keypressed())	// Press F6 to save a screenshot
		if ((readkey() >> 8) == KEY_F6)		
			save_bmp("shot.bmp", scrbuf, data[PAL_GAME].dat);

	blit (scrbuf, screen, 0, 0, 0, 0, scrx, scry);
}



int gfx_init(void)
{
	set_color_depth (bpp);
        if (set_gfx_mode (GFX_AUTODETECT, scrx, scry, 0, 0)) {
		return 1;
	}
	scrbuf = create_bitmap (scrx, scry);	
	clear (scrbuf);

	text_mode (-1);

	set_projection_viewport (0, 0, scrx, scry);

	return 0;
}


void use_gfx_mode (int b,int x,int y)
{
	bpp = b;
	scrx = x;
	scry = y;
}

void gfx_shutdown (void)
{
	destroy_bitmap (scrbuf);
	set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
}

int gfx_reset (void)
{
	destroy_bitmap (scrbuf);
	return gfx_init();
}

// Gfx-loop for menu
void gfx_menu_loop (void)
{
	int i;
	clear_to_color (scrbuf, 255);
	ellipsefill (scrbuf, 2 * scrx / 3, 2 * scry / 3, 8 * scrx / 13, 8 * scry / 13, 254);
	masked_stretch_blit(data[BMP_TITLE].dat, scrbuf, 0, 0, 127, 38, scrx / 32, scry / 32, 127 * scrx / 320, 38 * scrx / 320);
	for (i = 0; i < menu.items; i++)
	{
		if (!menu.disabled[i])
			textout_right (scrbuf, data[FNT_MEAD].dat, &menu.item[i][0], 8 * scrx / 9, (2+i) * scry / (menu.items+3), -1);
		else
			textout_right (scrbuf, data[FNT_MEAD].dat, &menu.item[i][0], 8 * scrx / 9, (2+i) * scry / (menu.items+3), 255);
		if (menu.active_item == i)
			textout (scrbuf, data[FNT_MEAD].dat, "<", 8 * scrx / 9, (2+i) * scry / (menu.items+3), -1);
	}

	textout (scrbuf, font, "Qubrikon v1.0 - by Per Larsson", 1, scry-9, 63);
	blit (scrbuf, screen, 0, 0, 0, 0, scrx, scry);
	
}

// End-screen
void gfx_grats (void)
{
	stretch_blit(data[BMP_GRATS].dat, screen, 0, 0, 640, 480, 0, 0, scrx, scry);
}
