#include <allegro.h>

#include "data.h"

#define SAWTOOTH_VOL		72
#define CRASH_FREQ_VARY		200

char no_digi, no_midi;



int sound_init(void)
{
	if (!detect_digi_driver(DIGI_AUTODETECT))
		no_digi = TRUE;

	if (detect_midi_driver(MIDI_AUTODETECT))
		no_midi = TRUE;
	
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL))
		return 1;
	
	return 0;
}

void play_menu_music (void)
{
	play_midi(data[MID_MENU].dat, TRUE);
}

void play_grats_music (void)
{
	play_midi(data[MID_GRATS].dat, TRUE);
}

void play_game_music (int level)
{
	play_midi(data[MID_TUNE1+(level%5)].dat, TRUE);
}

void sound_shutdown(void)
{
	stop_midi();
	remove_sound();
}


void start_sawtooth(void)
{
	if (!no_digi)
		play_sample(data[SMP_KNARR].dat, SAWTOOTH_VOL, 128, 1, TRUE);
}

void change_sawtooth(int freq)
{
	if (freq <= 0)
		freq = 1;
	if (!no_digi)
		adjust_sample(data[SMP_KNARR].dat, SAWTOOTH_VOL, 128, freq, TRUE);
}

void stop_sawtooth(void)
{
	if (!no_digi)
		stop_sample(data[SMP_KNARR].dat);
}

void play_crash(int vol)
{
	if (vol > 255)
		vol = 255;
	if (!no_digi)
		play_sample(data[SMP_DUNS].dat, vol, 128, (1000-CRASH_FREQ_VARY)+(rand()%(CRASH_FREQ_VARY*2)), FALSE);
}

void play_menu(int freq)
{
	if (!no_digi)
		play_sample(data[SMP_MENU].dat, 255, 128, freq, FALSE);
}

void play_menu2(void)
{
	if (!no_digi)
		play_sample(data[SMP_MENU2].dat, 196, 128, 1000, FALSE);
}

void play_menu3(void)
{
	if (!no_digi)
		play_sample(data[SMP_MENUMOVE].dat, 128, 128, 1000, FALSE);
}

void play_levelfinish(void)
{
	if (!no_digi)
		play_sample(data[SMP_LEVELFINISH].dat, 255, 128, 1000, FALSE);
}