#include <allegro.h>

#include "3d.h"
#include "gfx.h"
#include "map.h"
#include "game.h"
#include "data.h"
#include "sound.h"
#include "timer.h"
#include "menu.h"



int main_init(void)
{
	PACKFILE *config;
	int w, h;

	if (allegro_init())
		return 1;
	set_window_title("Qubrikon");
	install_keyboard ();
	install_mouse ();

	config = pack_fopen("qubrikon.sav", "r");
	if (!config)
	{
		w = 640;
		h = 480;
		clearlevel = 0;
	}
	else
	{
		pack_fread(&w, sizeof(int), config);
		pack_fread(&h, sizeof(int), config);
		pack_fread(&clearlevel, sizeof(int), config);
	}
	pack_fclose(config);

	use_gfx_mode (8, w, h);
	set_keyboard_rate(400, 200);

	return 0;
}

void main_shutdown()
{
	PACKFILE *config = pack_fopen("qubrikon.sav", "w");
	pack_fwrite(&scrx, sizeof(int), config);
	pack_fwrite(&scry, sizeof(int), config);
	pack_fwrite(&clearlevel, sizeof(int), config);
	pack_fclose(config);
}



int main(void)
{
	if (main_init ())
		return 1;
	
	if (threed_init ())
		return 1;
	
	if (timer_init ())
		return 1;

	if (data_init ())
		return 1;
	
	sound_init();		// Don't quit even if no soundcard is detected!

	if (gfx_init ())
		return 1;

	play_menu_music();
	menu_show ();
	
	main_shutdown();
	gfx_shutdown ();
	data_shutdown ();
	sound_shutdown ();
	allegro_exit ();

	return 0;
}
END_OF_MAIN();



