#include <allegro.h>
#include <stdio.h>
#include <math.h>

#include "player.h"
#include "map.h"
#include "gfx.h"
#include "pal.h"
#include "sound.h"
#include "timer.h"
#include "camera.h"

#define LEVELS	14

PLAYER player;
int endx, endz;
char game_on;
int level, clearlevel;
char nextlevel;
char game_end;

void load_level()
{
	char levelname[16];
	sprintf (levelname, "levels\\%02d.map", level);	
	load_map (levelname);
	gfx_game_loop();
	fade_in_game();
	play_game_music (level);
	timer_start ();
}

int game_init(void)
{
	player.direction = DIRECTION_NONE;
	player.angle = 0;
	level = clearlevel;
	load_level();
	game_on = TRUE;
	return 0;
}

void rotate_colors(void) 
{
	int old_color[6], i;
	
	for (i = 0; i<6; i++)
		old_color[i] = player.color[i];

	player.color[SIDE_BOTTOM] = old_color[player.direction+1];
	player.color[player.direction+1] = old_color[SIDE_TOP];
	player.color[SIDE_TOP] = old_color[((player.direction+2) % 4)+1];
	player.color[((player.direction+2) % 4)+1] = old_color[SIDE_BOTTOM];
}

float cosx(float x)
{
	return cos(x*3.14159/128);
}

void cube_land(void)
{
	stop_sawtooth();
	player.angle = 0;
	player.direction = DIRECTION_NONE;
	if ((player.x == endx) & (player.z == endz))
	{
		nextlevel = 1;
		play_levelfinish();
	}
	else
	{
		play_crash(abs(player.v*256)+63);
	}
	player.v = 0;

}


void next_level()
{
	level += nextlevel;
	nextlevel = 0;
	

	stop_midi();
	timer_stop ();
	fade_out_game();

	if (level > LEVELS)
	{
		game_end = TRUE;
	}
	else
	{
		if (level > clearlevel)
			clearlevel = level;

		load_level();
	}
}


int cube_color_ok(void)
{
	int mapx, mapz;
	
	mapx = player.x;
	mapz = player.z;
	if (player.direction == DIRECTION_LEFT)
		mapx--;
	if (player.direction == DIRECTION_RIGHT)
		mapx++;
	if (player.direction == DIRECTION_FRONT)
		mapz--;
	if (player.direction == DIRECTION_BACK)
		mapz++;
	
	if ((mapx < 0)|(mapz < 0)|(mapx > 15)|(mapz > 15))
		return 0;
	
	if ((map[mapx][mapz] == 7)|(player.color[(int)player.direction+1] == 7))
		return 1;

	if (map[mapx][mapz] == player.color[(int)player.direction+1])
		return 1;
	else
		return 0;

}

void grats(void)
{
	play_grats_music();
	gfx_grats();
	fade_in_grats();

	while (!key[KEY_ESC]) {}
			
	play_menu_music();
	game_on = FALSE;
	game_end = FALSE;
}

void game_loop(void) 
{
	float acc;
	float keyx, keyz;
	int key_direction;
	int last_timer, time=0;
	
	pal_game ();
	
	while (key[KEY_ESC])
		gfx_game_loop();
	
	timer_start ();
	last_timer = timer;

	while ((!key[KEY_ESC])&(!game_end))
	{
		keyx=keyz=acc=0;
		key_direction=DIRECTION_NONE;

		if ((key[KEY_PGUP])&&(level<clearlevel))
		{
			nextlevel = 1;
			play_menu3();
		}
		if ((key[KEY_PGDN])&&(level>0))
		{
			nextlevel = -1;
			play_menu3();
		}

		if (key[KEY_UP])
			key_direction=DIRECTION_BACK;
		if (key[KEY_DOWN])
			key_direction=DIRECTION_FRONT;
		if (key[KEY_LEFT])
			key_direction=DIRECTION_LEFT;
		if (key[KEY_RIGHT])
			key_direction=DIRECTION_RIGHT;
		
		if (key_direction != DIRECTION_NONE)	// Move the cube relative to the camera
			key_direction = (4 + key_direction - (((int)camera.yrot + 32)%256)/ 64) % 4;

		if (key_direction == DIRECTION_BACK)
			keyz=1;
		if (key_direction == DIRECTION_FRONT)
			keyz=-1;
		if (key_direction == DIRECTION_LEFT)
			keyx=-1;
		if (key_direction == DIRECTION_RIGHT)
			keyx=1;

		
		if (player.direction == DIRECTION_NONE)
		{
			if (keyz < 0)
				player.direction = DIRECTION_FRONT;
			if (keyz > 0)
				player.direction = DIRECTION_BACK;
			if (keyx < 0)
				player.direction = DIRECTION_LEFT;
			if (keyx > 0)
				player.direction = DIRECTION_RIGHT;
			if (player.direction != DIRECTION_NONE)
				start_sawtooth();
		}
		
		if (player.direction == DIRECTION_FRONT)
			acc = -keyz/200;
		if (player.direction == DIRECTION_BACK)
			acc = keyz/200;
		if (player.direction == DIRECTION_LEFT)
			acc = -keyx/200;
		if (player.direction == DIRECTION_RIGHT)
			acc = keyx/200;
		
		if (player.direction != DIRECTION_NONE) {
			if  (cube_color_ok())
				acc -= cosx(player.angle*2) / 300;
			else
				acc -= player.angle  / 2560;
			player.v += acc * time;
			player.angle += player.v * time;
			change_sawtooth(abs(player.v*3500));
		}

		time = timer-last_timer;
		last_timer = timer;
		
		if ((player.angle >= 64)&(player.direction != DIRECTION_NONE)&cube_color_ok())
		{
			if (player.direction == DIRECTION_FRONT)
				player.z--;
			if (player.direction == DIRECTION_BACK)
				player.z++;
			if (player.direction == DIRECTION_LEFT)
				player.x--;
			if (player.direction == DIRECTION_RIGHT)
				player.x++;

			rotate_colors();
			cube_land();
		}

		if ((player.angle <= 0)&(player.direction != DIRECTION_NONE))
		{
			cube_land();
		}
		
		gfx_game_loop();

		if (nextlevel)
			next_level();
	}
	stop_sawtooth();
	timer_stop ();

	if (game_end)
		grats();
}
