#include <allegro.h>

#include "3d.h"
#include "camera.h"
#include "player.h"

CAMERA camera;

float xrot, yrot, zrot;
V3D_f vertex[8];
V3D_f normal[8];
V3D_f light;
V3D_f star[NUM_STARS];
V3D_f rot_offset[4];
int quad[6][4];

// it was supposed to say 3d_init(), OKAY???
int threed_init(void)
{
	int i;

	vertex[0].x = -10;	// *-
	vertex[0].y = -10;	// | |
	vertex[0].z = -10;	//  -

	vertex[1].x = 10;	//  -*
	vertex[1].y = -10;	// | |
	vertex[1].z = -10;	//  -
	
	vertex[2].x = 10;	//  -
	vertex[2].y = 10;	// | |
	vertex[2].z = -10;	//  -*

	vertex[3].x = -10;	//  -
	vertex[3].y = 10;	// | |
	vertex[3].z = -10;	// *-
	
	vertex[4].x = -10;	// +-
	vertex[4].y = -10;	// | |
	vertex[4].z = 10;	//  -
	
	vertex[5].x = -10;	//  -
	vertex[5].y = 10;	// | |
	vertex[5].z = 10;	// +-
	
	vertex[6].x = 10;	//  -
	vertex[6].y = 10;	// | |
	vertex[6].z = 10;	//  -+
	
	vertex[7].x = 10;	//  -+
	vertex[7].y = -10;	// | |
	vertex[7].z = 10;	//  -
	
	quad [0][0] = 0;	// Top
	quad [0][1] = 4;
	quad [0][2] = 7;
	quad [0][3] = 1;

	quad [1][0] = 0;	// Left
	quad [1][1] = 3;
	quad [1][2] = 5;
	quad [1][3] = 4;

	quad [2][0] = 0;	// Front
	quad [2][1] = 1;
	quad [2][2] = 2;
	quad [2][3] = 3;

	quad [3][0] = 1;	// Right
	quad [3][1] = 7;
	quad [3][2] = 6;
	quad [3][3] = 2;
	
	quad [4][0] = 4;	// Back
	quad [4][1] = 5;
	quad [4][2] = 6;
	quad [4][3] = 7;
	
	quad [5][0] = 2;	// Bottom
	quad [5][1] = 6;
	quad [5][2] = 5;
	quad [5][3] = 3;
	
	for (i = 0; i < 8; i++)
	{
		//cross_product_f (vertex[quad[i][1]].x-vertex[quad[i][0]].x, vertex[quad[i][1]].y-vertex[quad[i][0]].y, vertex[quad[i][1]].z-vertex[quad[i][0]].z, vertex[quad[i][3]].x-vertex[quad[i][0]].x, vertex[quad[i][3]].y-vertex[quad[i][0]].y, vertex[quad[i][3]].z-vertex[quad[i][0]].z, &normal[i].x, &normal[i].y, &normal[i].z);
		normal[i].x = -vertex[i].x;
		normal[i].y = -vertex[i].y;
		normal[i].z = -vertex[i].z;
		normalize_vector_f (&normal[i].x, &normal[i].y, &normal[i].z);
	}
	
	light.x = -0.1;
	light.y = 1;
	light.z = 0.2;
	normalize_vector_f (&light.x, &light.y, &light.z);
	
	for (i = 0; i < NUM_STARS; i++)
	{
		star[i].x = (rand() % 1000) - 500;
		star[i].y = (rand() % 1000) - 500;
		star[i].z = (rand() % 1000) - 500;

		normalize_vector_f (&star[i].x, &star[i].y, &star[i].z);

		star[i].x = star[i].x * (LEN_STARS + rand() % SPA_STARS); 
		star[i].y = star[i].y * (LEN_STARS + rand() % SPA_STARS);
		star[i].z = star[i].z * (LEN_STARS + rand() % SPA_STARS);

		star[i].x += 160;
		star[i].z += 160;

		star[i].c = (rand() % 31)+1;
	}
	
	camera.distance = 100;
	camera.fov = 48;
	camera.yrot = 16;
	camera.xrot = -34;

	rot_offset[DIRECTION_LEFT].x = 10;
	rot_offset[DIRECTION_LEFT].y = -10;
	rot_offset[DIRECTION_LEFT].z = 0;

	rot_offset[DIRECTION_FRONT].x = 0;
	rot_offset[DIRECTION_FRONT].y = -10;
	rot_offset[DIRECTION_FRONT].z = 10;

	rot_offset[DIRECTION_RIGHT].x = -10;
	rot_offset[DIRECTION_RIGHT].y = -10;
	rot_offset[DIRECTION_RIGHT].z = 0;

	rot_offset[DIRECTION_BACK].x = 0;
	rot_offset[DIRECTION_BACK].y = -10;
	rot_offset[DIRECTION_BACK].z = -10;

	return 0;
}