/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "vislst3d.h"

VisualList3DClass* Target3DList;

LinkClass* VisualLink3DMaker(ObjectClass* obj)
{ return((LinkClass*)new VisualLink3DClass(obj));
}

VisualLink3DClass::VisualLink3DClass(ObjectClass* obj)
  : VisualLinkClass(obj)
{ Z = D = 0;
  // X, Y, Z are really only temporary variables are they are only true for a given view
}

bool VisualLink3DClass::Inside(int x,int y,int z)
{ // assumes X,Y,Z have been updated for the the current view
  return(Visible &&
          x >= X && x < X + W &&
          y >= Y && y < Y + H &&
          z >= Z && z < Z + D &&
          Control->Inside(Object,x,y));
}

bool VisualLink3DClass::Includes(int x1,int y1,int x2,int y2,int z1,int z2)
{
  return(Visible &&
         x1 <= X && x2 >= X+W-1 &&
         y1 <= Y && y2 >= Y+H-1 &&
         z1 <= Z && z1 >= Z+D-1 &&
         Control->Include(Object,x1,y1,x2,y2));
}

void VisualLink3DClass::Update()
{
  ((Object3DControlClass*)Control)->GetLimits(Object,X,Y,Z,W,H,D);  // = Visible
  // setting Visible conflicted with use in edit.cpp show and hide selected
  LinkClass::Update();
}

void VisualLink3DClass::Draw(BITMAP* bmp)
{
  if(Visible)
    Control->Draw(bmp,Object);
}

VisualList3DClass::VisualList3DClass()
{
  LinkMaker = VisualLink3DMaker;   // global point in LinkClass
}

VisualLinkClass* VisualList3DClass::Add(ObjectClass* object, ObjectControlClass* control,
                                                   LinkClass* p)
{ VisualLinkClass* vl = (VisualLinkClass*)LinkMaker(object);
  if(vl) {
    vl->Control = (Object3DControlClass*)control;
    Insert(vl,p);
  }
  return(vl);
}

VisualLinkClass* VisualList3DClass::CreateLink(ObjectClass* obj, ObjectControlClass* control)
{
  VisualLink3DClass* vl = (VisualLink3DClass*)LinkMaker(obj);
  if(vl) {
    vl->Control = (Object3DControlClass*)control;
    Insert(vl);
  }
  return vl;
}

#include "view.h"

VisualLink3DClass* VisualList3DClass::Add(ObjectControlClass* control,
                                           int x, int y, int w, int h)
{
   VisualLink3DClass* vl = (VisualLink3DClass*)(VisualListClass::Add(control,x,y,w,h));
   vl->Z = fixtoi(Current_Visual->Depth);
   vl->D = 1;
   return vl;
}

#define BEGIN_LIST VisualLink3DClass* l = (VisualLink3DClass*)FirstLink(); while(l && l != Undone) {
#define END_LIST   l = (VisualLink3DClass*)l->NextLink(); }

void VisualList3DClass::Update()
{
  BEGIN_LIST
    ((VisualLink3DClass*)l)->Update();  // sets Visible
//    ((Object3DControlClass*)(l->Control))->GetLimits(l->Object,l->X,l->Y,l->Z,l->W,l->H,l->D);
  END_LIST
}

VisualLinkClass* VisualList3DClass::Find_Mouse_Object()
{
  int mx, my;
  mx = mouse_x;
  my = mouse_y;
  if(!ObjectSnap) {
    VisualLinkClass* vl = Find_Object(mx,my);   // limited to drawing plane
    if(vl)
      return vl;
  }
  return(VisualListClass::Find_Mouse_Object());
}

// the VisualListClass version wouldn't find the correct Inside function
VisualLinkClass* VisualList3DClass::Find_Object(int x, int y)
{ // FindOnly is a bit redundant as Inside should call Current_Visual->Include(type)
  int z = fixtoi(Current_Visual->Depth);
  BEGIN_LIST
    if((!FindOnly || l->Control == FindOnly) &&
      l->Inside(x,y,z))
      return(l);
  END_LIST
  return NULL;
}

