/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "texture.h"

unsigned Textures = 0;
ListClass TextureList;
TextureClass* Action_Texture = NULL;  // the texture used for new faces

TextureClass::TextureClass() : ObjectClass()
{
  Name = NULL;
  Textures++;
  BitMap = NULL;
  ID = Textures;
  DeleteOnZero = true;
}

TextureClass::~TextureClass()
{
  if(Name)
    delete Name;
  Textures--;
  if(BitMap)
    delete BitMap;
}

#include "stdio.h"

char* Texture_Selector(int index, int* size)   // used by properties() in edit.cpp
{                                           // via face.cpp getproperty()
  static char dname[5];
  if(index < 0) {
    *size = Textures + 1;
    return NULL;
  }
  if(index == 0)
    return("NULL TEXTURE???");
  LinkClass* link = TextureList.Find(index - 1);
  if(link)
  { TextureClass* texture = (TextureClass*)link->Object;
    if(texture)
    { if(texture->Name)
        return(texture->Name);
      sprintf(dname,"T%3d",texture->ID);
      return(dname);
    }
  }
  else
    return("TEXTURE DOESN'T SEEM TO EXIST");
}

#include "string.h"

int Find_Texture(char* name) {
  LinkClass* l = TextureList.FirstLink();
  int i;
  while(l) {
    if(l->Object && strncmp(((TextureClass*)(l->Object))->Name,name,MAX_TEXTURE_NAME) == 0)
    { return i;
    }
    l = l->NextLink();
    i++;
  }
}

