/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef SPACEHPP
#define SPACEHPP

#include <allegro.h>

class VTX
{
public:
  fixed X, Y, Z;
  VTX operator+(VTX& v);
  VTX operator-(VTX& v);
  VTX operator-();
  void Set(fixed,fixed,fixed);
  void Get(fixed&,fixed&,fixed&);
  void Min(fixed&,fixed&,fixed&);
  void Max(fixed&,fixed&,fixed&);
};

class SpaceClass
{
public:
  fixed X,  Y,  Z,  Rx,  Ry,  Rz;
  fixed dX, dY, dZ, dRx, dRy, dRz;
  fixed aX, aY, aZ, aRx, aRy, aRz;
  fixed Scale;
  SpaceClass();
  void Normalise();
  void MoveBy(fixed,fixed,fixed);
  void PanTo(fixed,fixed,fixed);
  void PanBy(fixed,fixed,fixed);
  void Delta(fixed,fixed,fixed,fixed,fixed,fixed,fixed);
  void NegDelta(fixed,fixed,fixed,fixed,fixed,fixed,fixed);
  bool Orthagonal();
  bool SamePos(SpaceClass*);
};

#endif
