/*  Source file for the Edit3d program by Robert Parker using the Allegro
    and Bgui2 - see credits else where - also see BasicGUI source code.
    Copyright (C) 2001-2004  Robert Parker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "space.h"

// use allegro fixed number routines to improve overflow error check

VTX VTX::operator+(VTX& v)
{ VTX a;
  a.X = fadd(X,v.X);
  a.Y = fadd(Y,v.Y);
  a.Z = fadd(Z,v.Z);
  return a;
}

VTX VTX::operator-(VTX& v)
{ VTX a;
  a.X = fsub(X,v.X);
  a.Y = fsub(Y,v.Y);
  a.Z = fsub(Z,v.Z);
  return a;
}

VTX VTX::operator-(void)
{ VTX a;
  a.X = -X;
  a.Y = -Y;
  a.Z = -Z;
  return a;
}

void VTX::Set(fixed x, fixed y, fixed z)
{
  X = x;
  Y = y;
  Z = z;
}

void VTX::Get(fixed& x, fixed& y, fixed& z)
{
  x = X;
  y = Y;
  z = Z;
}

void VTX::Min(fixed& x, fixed& y, fixed& z)
{
  if(X < x)
    x = X;
  if(Y < y)
    y = Y;
  if(Z < z)
    z = Z;
}

void VTX::Max(fixed& x, fixed& y, fixed& z)
{
  if(X > x)
    x = X;
  if(Y > y)
    y = Y;
  if(Z > z)
    z = Z;
}

SpaceClass::SpaceClass()
{
  X = Y = Z = Rx = Ry = Rz = dZ = dY = dZ = dRx = dRy = dRz = 0;
  aX = aY = aZ = aRx = aRy = aRz = 0;
  Scale = 1<<16;
}

void SpaceClass::MoveBy(fixed dx, fixed dy, fixed dz)
{
  X += dx;
  Y += dy;
  Z += dz;
}

void SpaceClass::PanTo(fixed rx, fixed ry, fixed rz)
{
  Rx = rx;
  Ry = ry;
  Rz = rz;
}

void SpaceClass::PanBy(fixed rx, fixed ry, fixed rz)
{
  // it's not really this simple - ***** temporary ************
  Rx += rx;
  Ry += ry;
  Rz += rz;
}

void SpaceClass::Delta(fixed dx, fixed dy, fixed dz,fixed rx, fixed ry, fixed rz, fixed sc)
{
  X += dx;
  Y += dy;
  Z += dz;
  Rx += rx;
  Ry += ry;
  Rz += rz;
  Scale = fmul(Scale,sc);
}

void SpaceClass::NegDelta(fixed dx, fixed dy, fixed dz,fixed rx, fixed ry, fixed rz, fixed sc)
{
  X -= dx;
  Y -= dy;
  Z -= dz;
  Rx -= rx;  // it's not really that simple
  Ry -= ry;
  Rz -= rz;
  Scale = fdiv(Scale,sc);
}

bool SpaceClass::Orthagonal()
{
  const long orth = 64<<16 - 1;
  return(((Rx & orth)== 0) && ((Ry & orth)== 0) &&((Rz & orth)== 0));
}

bool SpaceClass::SamePos(SpaceClass* sp)
{
  return((X == sp->X) && (Y == sp->Y) && (Z == sp->Z));
}

void SpaceClass::Normalise() // reduce angles to less than 360deg
{
  Rx %= 256<<16;
  Ry %= 256<<16;
  Rz %= 256<<16;

  if(Rx < 0)
    Rx += 256<<16;
  if(Ry < 0)
    Ry += 256<<16;
  if(Rz < 0)
    Rz += 256<<16;

}


